/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level;

import com.google.common.base.Preconditions;
import java.time.Duration;
import net.kyori.adventure.util.Ticks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerTickList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.spongepowered.api.scheduler.ScheduledUpdate;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.ServerTickListAccessor;
import org.spongepowered.common.bridge.world.level.TickNextTickDataBridge;

@Mixin(value={NextTickListEntry.class})
public abstract class TickNextTickDataMixin<T>
implements TickNextTickDataBridge<T> {
    @Shadow
    @Final
    public BlockPos field_180282_a;
    @Shadow
    @Final
    private T field_151352_g;
    @Shadow
    @Final
    public long field_235017_b_;
    private @MonotonicNonNull ServerLocation impl$location;
    private @MonotonicNonNull ServerTickList<T> impl$parentTickList;
    private long impl$scheduledTime;
    private ScheduledUpdate.State impl$state = ScheduledUpdate.State.WAITING;

    @Override
    public void bridge$createdByList(ServerTickList<T> tickList) {
        this.impl$parentTickList = tickList;
        this.impl$scheduledTime = ((ServerTickListAccessor)tickList).accessor$level().func_82737_E();
    }

    @Override
    public void bridge$setWorld(World world) {
        Preconditions.checkState((this.impl$location == null ? 1 : 0) != 0, (Object)"World already known");
        BlockPos position = this.field_180282_a;
        this.impl$location = ServerLocation.of((ServerWorld)world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    @Override
    public ServerLocation bridge$getLocation() {
        Preconditions.checkState((this.impl$location != null ? 1 : 0) != 0, (Object)"Unable to determine location at this time");
        return this.impl$location;
    }

    @Override
    public ScheduledUpdate.State bridge$internalState() {
        if (this.impl$parentTickList == null) {
            return ScheduledUpdate.State.CANCELLED;
        }
        return this.impl$state;
    }

    @Override
    public void bridge$setState(ScheduledUpdate.State state) {
        this.impl$state = state;
    }

    @Override
    public boolean bridge$cancelForcibly() {
        if (this.impl$parentTickList == null) {
            return false;
        }
        if (this.impl$state == ScheduledUpdate.State.FINISHED) {
            return false;
        }
        this.impl$state = ScheduledUpdate.State.CANCELLED;
        return true;
    }

    @Override
    public Duration bridge$getScheduledDelayWhenCreated() {
        return Ticks.duration((long)(this.field_235017_b_ - this.impl$scheduledTime));
    }
}

