/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.block.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.CustomNameableBridge;
import org.spongepowered.common.bridge.world.level.block.entity.BannerBlockEntityBridge;
import org.spongepowered.common.data.provider.item.stack.ShieldItemStackData;
import org.spongepowered.common.mixin.core.world.level.block.entity.BlockEntityMixin;

@Mixin(value={BannerTileEntity.class})
public abstract class BannerBlockEntityMixin
extends BlockEntityMixin
implements BannerBlockEntityBridge,
CustomNameableBridge {
    @Shadow
    private net.minecraft.item.DyeColor field_175120_a;
    @Shadow
    private ListNBT field_175118_f;
    private List<BannerPatternLayer> impl$patternLayers = Lists.newArrayList();

    @Inject(method={"func_230337_a_(Lnet/minecraft/block/BlockState;Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="RETURN")})
    private void onSetItemValues(CallbackInfo ci) {
        this.impl$updatePatterns();
    }

    private void impl$markDirtyAndUpdate() {
        this.shadow$func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ((ServerWorld)this.field_145850_b).func_72863_F().func_217217_a(this.shadow$func_174877_v());
        }
    }

    private void impl$updatePatterns() {
        this.impl$patternLayers.clear();
        if (this.field_175118_f != null) {
            for (INBT pattern : this.field_175118_f) {
                this.impl$patternLayers.add(ShieldItemStackData.layerFromNbt((CompoundNBT)pattern));
            }
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public List<BannerPatternLayer> bridge$getLayers() {
        return new ArrayList<BannerPatternLayer>(this.impl$patternLayers);
    }

    @Override
    public void bridge$setLayers(List<BannerPatternLayer> layers) {
        this.impl$patternLayers = NonNullList.func_191196_a();
        this.impl$patternLayers.addAll(layers);
        this.field_175118_f = new ListNBT();
        for (BannerPatternLayer layer : this.impl$patternLayers) {
            this.field_175118_f.add((Object)ShieldItemStackData.layerToNbt(layer));
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public DyeColor bridge$getBaseColor() {
        return (DyeColor)this.field_175120_a;
    }

    @Override
    public void bridge$setBaseColor(DyeColor baseColor) {
        Preconditions.checkNotNull((Object)baseColor, (Object)"Null DyeColor!");
        try {
            this.field_175120_a = (net.minecraft.item.DyeColor)baseColor;
        }
        catch (Exception e) {
            this.field_175120_a = net.minecraft.item.DyeColor.BLACK;
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public void bridge$setCustomDisplayName(ITextComponent customName) {
        ((BannerTileEntity)this).func_213136_a(customName);
    }
}

