/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.border;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.border.WorldBorder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.ChangeWorldBorderEvent;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.world.border.SpongeWorldBorderBuilder;

@Mixin(value={net.minecraft.world.border.WorldBorder.class})
public abstract class WorldBorderMixin
implements WorldBorderBridge {
    private ResourceKey impl$associatedWorld;
    private boolean impl$fireEvent = true;

    @Override
    public void bridge$setAssociatedWorld(ResourceKey associatedWorld) {
        this.impl$associatedWorld = associatedWorld;
    }

    @Inject(method={"func_177739_c(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetCenter(double x, double z, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).center(x, z).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177750_a(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetSize(double size, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).targetDiameter(size).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177738_a(DDJ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onLerping(double initial, double target, long milliseconds, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).initialDiameter(initial).targetDiameter(target).timeToTargetDiameter(Duration.ofMillis(milliseconds)).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177747_c(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetWarningBlocks(int distance, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).warningDistance(distance).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177724_b(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetDamageSafeZone(double size, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).safeZone(size).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177744_c(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetDamagePerBlock(double damagePerBlock, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).damagePerBlock(damagePerBlock).build())) {
            ci.cancel();
        }
    }

    @Inject(method={"func_177723_b(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onSetWarningTime(int warningTime, CallbackInfo ci) {
        Supplier<WorldBorder> proposed;
        if (this.impl$fireEvent && this.impl$suppressOriginalAction(proposed = () -> new SpongeWorldBorderBuilder().from(this).warningTime(Duration.ofSeconds(warningTime)).build())) {
            ci.cancel();
        }
    }

    private boolean impl$suppressOriginalAction(Supplier<WorldBorder> proposed) {
        ChangeWorldBorderEvent.World result = this.impl$fireWorldBorderEvent(proposed);
        return result != null && (result.isCancelled() || result.originalNewBorder().orElse(null) != result.newBorder().orElse(null));
    }

    private @Nullable ChangeWorldBorderEvent.World impl$fireWorldBorderEvent(Supplier<WorldBorder> proposed) {
        Optional<ServerWorld> world;
        if (this.impl$associatedWorld != null && SpongeCommon.game().isServerAvailable() && (world = Sponge.server().worldManager().world(this.impl$associatedWorld)).isPresent()) {
            ChangeWorldBorderEvent.World event = SpongeEventFactory.createChangeWorldBorderEventWorld(PhaseTracker.getCauseStackManager().currentCause(), Optional.of(proposed.get()), Optional.of(proposed.get()), Optional.of(this.bridge$asImmutable()), world.get());
            boolean isCancelled = Sponge.eventManager().post(event);
            if (!isCancelled) {
                WorldBorder toSet = event.newBorder().orElse((WorldBorder)net.minecraft.world.border.WorldBorder.field_235925_b_);
                if (proposed.get() != toSet) {
                    this.impl$fireEvent = false;
                    this.bridge$applyFrom(toSet);
                    this.impl$fireEvent = true;
                }
            }
            return event;
        }
        return null;
    }

    @Override
    public WorldBorder bridge$asImmutable() {
        return (WorldBorder)((net.minecraft.world.border.WorldBorder)this).func_235927_t_();
    }

    @Override
    public @Nullable WorldBorder bridge$applyFrom(WorldBorder worldBorder) {
        WorldBorder toSet;
        ChangeWorldBorderEvent.World event = this.impl$fireWorldBorderEvent(() -> worldBorder);
        if (event != null) {
            if (event.isCancelled()) {
                return this.bridge$asImmutable();
            }
            WorldBorder defaultSettings = (WorldBorder)net.minecraft.world.border.WorldBorder.field_235925_b_;
            toSet = event.newBorder().orElse(defaultSettings);
        } else {
            toSet = worldBorder;
        }
        this.impl$fireEvent = false;
        ((net.minecraft.world.border.WorldBorder)this).func_235926_a_((WorldBorder.Serializer)toSet);
        this.impl$fireEvent = true;
        return toSet;
    }
}

