/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.chunk;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerChunkProvider;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.CacheKeyBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DirectionUtil;

@Mixin(value={Chunk.class})
public abstract class LevelChunkMixin
implements LevelChunkBridge,
CacheKeyBridge {
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    @Final
    private ChunkPos field_212816_F;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<net.minecraft.entity.Entity>[] field_76645_j;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> field_150816_i;
    @Shadow
    private boolean field_76636_d;
    @Shadow
    private boolean field_76643_l;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final Chunk[] impl$neighbors = new Chunk[4];
    private long impl$cacheKey;
    private Map<Integer, PlayerTracker> impl$trackedIntBlockPositions = new HashMap<Integer, PlayerTracker>();
    private Map<Short, PlayerTracker> impl$trackedShortBlockPositions = new HashMap<Short, PlayerTracker>();

    @Shadow
    @Nullable
    public abstract TileEntity shadow$func_177424_a(BlockPos var1, Chunk.CreateEntityType var2);

    @Shadow
    public abstract BlockState shadow$func_180495_p(BlockPos var1);

    @Shadow
    public abstract void shadow$func_76612_a(net.minecraft.entity.Entity var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/world/biome/BiomeContainer;Lnet/minecraft/util/palette/UpgradeData;Lnet/minecraft/world/ITickList;Lnet/minecraft/world/ITickList;J[Lnet/minecraft/world/chunk/ChunkSection;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(World p_i225781_1_, ChunkPos p_i225781_2_, BiomeContainer p_i225781_3_, UpgradeData p_i225781_4_, ITickList<Block> p_i225781_5_, ITickList<Fluid> p_i225781_6_, long p_i225781_7_, ChunkSection[] p_i225781_9_, Consumer<Chunk> p_i225781_10_, CallbackInfo ci) {
        this.impl$cacheKey = ChunkPos.func_77272_a((int)p_i225781_2_.field_77276_a, (int)p_i225781_2_.field_77275_b);
    }

    @Override
    public Chunk[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.field_76643_l = true;
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        return ((ChunkMapAccessor)((ServerChunkProvider)this.field_76637_e.func_72863_F()).field_217237_a).accessor$pendingUnloads().containsKey(this.field_212816_F.func_201841_a());
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return this.impl$trackedIntBlockPositions;
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return this.impl$trackedShortBlockPositions;
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
        this.impl$trackedIntBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
        this.impl$trackedShortBlockPositions = trackedPositions;
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, UUID uuid, PlayerTracker.Type trackerType) {
        if (((LevelBridge)this.field_76637_e).bridge$isFake()) {
            return;
        }
        if (!PhaseTracker.getInstance().getPhaseContext().tracksCreatorsAndNotifiers()) {
            return;
        }
        TileEntity blockEntity = this.field_150816_i.get(pos);
        if (blockEntity != null && blockEntity instanceof CreatorTrackedBridge) {
            CreatorTrackedBridge trackedBlockEntity = (CreatorTrackedBridge)blockEntity;
            if (trackerType == PlayerTracker.Type.NOTIFIER) {
                if (Objects.equals(trackedBlockEntity.tracker$getNotifierUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.NOTIFIER, uuid);
            } else {
                if (Objects.equals(trackedBlockEntity.tracker$getCreatorUUID().orElse(null), uuid)) {
                    return;
                }
                trackedBlockEntity.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, uuid);
            }
        }
        if (trackerType == PlayerTracker.Type.CREATOR) {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.creatorindex = idx;
                pt.notifierIndex = idx;
            });
        } else {
            this.impl$setTrackedUUID(pos, uuid, trackerType, (pt, idx) -> {
                pt.notifierIndex = idx;
            });
        }
    }

    public Optional<UUID> bridge$trackedUUID(BlockPos pos, Function<PlayerTracker, Integer> func) {
        if (((LevelBridge)this.field_76637_e).bridge$isFake()) {
            return Optional.empty();
        }
        int key = Constants.Sponge.blockPosToInt(pos);
        PlayerTracker intTracker = this.impl$trackedIntBlockPositions.get(key);
        if (intTracker != null) {
            int ownerIndex = func.apply(intTracker);
            return this.impl$getValidatedUUID(key, ownerIndex);
        }
        short shortKey = Constants.Sponge.blockPosToShort(pos);
        PlayerTracker shortTracker = this.impl$trackedShortBlockPositions.get(shortKey);
        if (shortTracker != null) {
            int ownerIndex = func.apply(shortTracker);
            return this.impl$getValidatedUUID(shortKey, ownerIndex);
        }
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.creatorindex);
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        return this.bridge$trackedUUID(pos, pt -> pt.notifierIndex);
    }

    private <T> void impl$computePlayerTracker(Map<T, PlayerTracker> map, T blockPos, int index, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        PlayerTracker tracker = map.get(blockPos);
        if (tracker != null) {
            consumer.accept(tracker, index);
        } else {
            map.put(blockPos, new PlayerTracker(index, type));
        }
    }

    private void impl$setTrackedUUID(BlockPos pos, UUID uuid, PlayerTracker.Type type, BiConsumer<PlayerTracker, Integer> consumer) {
        int index;
        if (((LevelBridge)this.field_76637_e).bridge$isFake()) {
            return;
        }
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.field_76637_e.func_72912_H();
        int n = index = uuid == null ? -1 : worldInfo.bridge$getIndexForUniqueId(uuid);
        if (pos.func_177956_o() <= 255) {
            short blockPos = Constants.Sponge.blockPosToShort(pos);
            this.impl$computePlayerTracker(this.impl$trackedShortBlockPositions, blockPos, index, type, consumer);
            return;
        }
        int blockPos = Constants.Sponge.blockPosToInt(pos);
        this.impl$computePlayerTracker(this.impl$trackedIntBlockPositions, blockPos, index, type, consumer);
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.NOTIFIER, (pt, idx) -> {
            pt.notifierIndex = idx;
        });
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
        this.impl$setTrackedUUID(pos, uuid, PlayerTracker.Type.CREATOR, (pt, idx) -> {
            pt.creatorindex = idx;
        });
    }

    private Optional<UUID> impl$getValidatedUUID(int key, int ownerIndex) {
        PrimaryLevelDataBridge worldInfo = (PrimaryLevelDataBridge)this.field_76637_e.func_72912_H();
        UUID uuid = worldInfo.bridge$getUniqueIdForIndex(ownerIndex).orElse(null);
        if (uuid != null) {
            if (SpongeConfigs.getCommon().get().world.invalidLookupUuids.contains(uuid)) {
                if (key <= Short.MAX_VALUE) {
                    this.impl$trackedShortBlockPositions.remove((short)key);
                }
                this.impl$trackedIntBlockPositions.remove(key);
                return Optional.empty();
            }
            return Optional.of(uuid);
        }
        return Optional.empty();
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable Chunk chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    @Nullable
    public Chunk bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<Chunk> bridge$getNeighbors() {
        ArrayList<Chunk> neighborList = new ArrayList<Chunk>();
        for (Chunk neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable Chunk neighbor) {
        this.impl$neighbors[DirectionUtil.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.field_76636_d && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.field_76637_e).add("Position", (Object)(this.field_212816_F.field_77276_a + ":" + this.field_212816_F.field_77275_b)).add("super", (Object)super.toString()).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }

    @Override
    public boolean bridge$spawnEntity(Entity entity) {
        net.minecraft.entity.Entity mcEntity = (net.minecraft.entity.Entity)entity;
        BlockPos blockPos = mcEntity.func_233580_cy_();
        if (this.field_212816_F.field_77276_a == blockPos.func_177958_n() >> 4 && this.field_212816_F.field_77275_b == blockPos.func_177952_p() >> 4) {
            this.field_76637_e.func_217376_c(mcEntity);
            return true;
        }
        return false;
    }
}

