/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.dimension;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Dimension;
import net.minecraft.world.storage.ServerWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.world.server.SpongeWorldTemplate;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={Dimension.class})
public abstract class LevelStemMixin
implements LevelStemBridge,
ResourceKeyBridge {
    @Shadow
    @Final
    @Mutable
    public static Codec<Dimension> field_236052_a_;
    private ResourceKey impl$key;
    private ResourceLocation impl$gameMode;
    private @Nullable ResourceLocation impl$difficulty;
    private SerializationBehavior impl$serializationBehavior = null;
    private @Nullable Component impl$displayName = null;
    private Integer impl$viewDistance = null;
    private @Nullable Vector3i impl$spawnPosition;
    private @Nullable Boolean impl$hardcore;
    private @Nullable Boolean impl$pvp;
    private @Nullable Boolean impl$commands;
    private boolean impl$loadOnStartup = true;
    private boolean impl$performsSpawnLogic = false;
    private boolean impl$fromSettings = true;

    @Inject(method={"<clinit>()V"}, at={@At(value="RETURN")})
    private static void impl$useTemplateCodec(CallbackInfo ci) {
        field_236052_a_ = SpongeWorldTemplate.DIRECT_CODEC;
    }

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public Optional<Component> bridge$displayName() {
        return Optional.ofNullable(this.impl$displayName);
    }

    @Override
    public Optional<ResourceLocation> bridge$gameMode() {
        return Optional.ofNullable(this.impl$gameMode);
    }

    @Override
    public Optional<ResourceLocation> bridge$difficulty() {
        return Optional.ofNullable(this.impl$difficulty);
    }

    @Override
    public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.ofNullable(this.impl$serializationBehavior);
    }

    @Override
    public Optional<Integer> bridge$viewDistance() {
        return Optional.ofNullable(this.impl$viewDistance);
    }

    @Override
    public Optional<Vector3i> bridge$spawnPosition() {
        return Optional.ofNullable(this.impl$spawnPosition);
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public Optional<Boolean> bridge$hardcore() {
        return Optional.ofNullable(this.impl$hardcore);
    }

    @Override
    public Optional<Boolean> bridge$commands() {
        return Optional.ofNullable(this.impl$commands);
    }

    @Override
    public Optional<Boolean> bridge$pvp() {
        return Optional.ofNullable(this.impl$pvp);
    }

    @Override
    public boolean bridge$fromSettings() {
        return this.impl$fromSettings;
    }

    @Override
    public void bridge$setFromSettings(boolean fromSettings) {
        this.impl$fromSettings = fromSettings;
    }

    @Override
    public Dimension bridge$decorateData(SpongeWorldTemplate.SpongeDataSection data) {
        this.impl$gameMode = data.gameMode;
        this.impl$difficulty = data.difficulty;
        this.impl$serializationBehavior = data.serializationBehavior;
        this.impl$displayName = data.displayName;
        this.impl$viewDistance = data.viewDistance;
        this.impl$spawnPosition = data.spawnPosition;
        this.impl$loadOnStartup = data.loadOnStartup == null || data.loadOnStartup != false;
        this.impl$performsSpawnLogic = data.performsSpawnLogic != null && data.performsSpawnLogic != false;
        this.impl$hardcore = data.hardcore;
        this.impl$commands = data.commands;
        this.impl$pvp = data.pvp;
        return (Dimension)this;
    }

    @Override
    public SpongeWorldTemplate.SpongeDataSection bridge$createData() {
        return new SpongeWorldTemplate.SpongeDataSection(this.bridge$displayName().orElse(null), this.bridge$gameMode().orElse(null), this.bridge$difficulty().orElse(null), this.bridge$serializationBehavior().orElse(null), this.bridge$viewDistance().orElse(null), this.bridge$spawnPosition().orElse(null), this.bridge$loadOnStartup(), this.bridge$performsSpawnLogic(), this.bridge$hardcore().orElse(null), this.bridge$commands().orElse(null), this.bridge$pvp().orElse(null));
    }

    @Override
    public void bridge$populateFromTemplate(SpongeWorldTemplate s2) {
        this.impl$key = s2.key();
        this.impl$gameMode = s2.gameMode == null ? null : (ResourceLocation)s2.gameMode.location();
        this.impl$difficulty = s2.difficulty == null ? null : (ResourceLocation)s2.difficulty.location();
        this.impl$serializationBehavior = s2.serializationBehavior;
        this.impl$displayName = s2.displayName;
        this.impl$viewDistance = s2.viewDistance;
        this.impl$spawnPosition = s2.spawnPosition;
        this.impl$loadOnStartup = s2.loadOnStartup;
        this.impl$performsSpawnLogic = s2.performsSpawnLogic;
        this.impl$hardcore = s2.hardcore;
        this.impl$commands = s2.commands;
        this.impl$pvp = s2.pvp;
    }

    @Override
    public void bridge$populateFromLevelData(ServerWorldInfo levelData) {
        PrimaryLevelDataBridge levelDataBridge = (PrimaryLevelDataBridge)levelData;
        this.impl$gameMode = (ResourceLocation)RegistryTypes.GAME_MODE.get().valueKey((GameMode)levelData.func_76077_q());
        this.impl$difficulty = (ResourceLocation)RegistryTypes.DIFFICULTY.get().valueKey((Difficulty)levelData.func_176130_y());
        this.impl$serializationBehavior = levelDataBridge.bridge$serializationBehavior().orElse(null);
        this.impl$displayName = levelDataBridge.bridge$displayName().orElse(null);
        this.impl$viewDistance = levelDataBridge.bridge$viewDistance().orElse(null);
        this.impl$spawnPosition = new Vector3i(levelData.func_76079_c(), levelData.func_76075_d(), levelData.func_76074_e());
        this.impl$loadOnStartup = levelDataBridge.bridge$loadOnStartup();
        this.impl$performsSpawnLogic = levelDataBridge.bridge$performsSpawnLogic();
        this.impl$hardcore = levelData.func_76093_s();
        this.impl$commands = levelData.func_76086_u();
        this.impl$pvp = levelDataBridge.bridge$pvp().orElse(null);
    }

    @Override
    public SpongeWorldTemplate bridge$asTemplate() {
        return new SpongeWorldTemplate((Dimension)this);
    }
}

