/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.storage.PlayerData;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.util.FileUtil;

@Mixin(value={PlayerData.class})
public abstract class PlayerDataStorageMixin {
    @Shadow
    @Final
    private File field_237333_c_;
    private @Nullable Exception impl$capturedException;

    @Redirect(method={"func_237336_b_(Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;func_70020_e(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$readSpongePlayerData(PlayerEntity playerEntity, CompoundNBT compound) throws IOException {
        playerEntity.func_70020_e(compound);
        Path file = new File(this.field_237333_c_, playerEntity.func_189512_bd() + ".dat").toPath();
        Instant creationTime = Files.exists(file, new LinkOption[0]) ? Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant() : null;
        ((SpongeServer)SpongeCommon.server()).getPlayerDataManager().readPlayerData(compound, null, creationTime);
    }

    @Redirect(method={"func_237336_b_(Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;func_244263_a(Ljava/io/File;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$wrapFileRead(File param0) throws IOException {
        try {
            return CompressedStreamTools.func_244263_a((File)param0);
        }
        catch (IOException exception) {
            FileUtil.copyCorruptedFile(param0);
            throw exception;
        }
    }

    @Inject(method={"func_237336_b_(Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/nbt/CompoundNBT;"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$onFailedLoad(PlayerEntity param0, CallbackInfoReturnable<CompoundNBT> cir, CompoundNBT tag, Exception exception) {
        throw new RuntimeException(exception);
    }

    @Inject(method={"func_237335_a_(Lnet/minecraft/entity/player/PlayerEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;func_244264_a(Lnet/minecraft/nbt/CompoundNBT;Ljava/io/File;)V", shift=At.Shift.AFTER)})
    private void impl$saveSpongePlayerData(PlayerEntity player, CallbackInfo callbackInfo) {
        ((SpongeServer)Sponge.server()).getPlayerDataManager().saveSpongePlayerData(player.func_110124_au());
    }

    @Inject(method={"func_237335_a_(Lnet/minecraft/entity/player/PlayerEntity;)V"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$trackExceptionForLogging(PlayerEntity player, CallbackInfo ci, Exception exception) {
        this.impl$capturedException = exception;
    }

    @Redirect(method={"func_237335_a_(Lnet/minecraft/entity/player/PlayerEntity;)V"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false))
    private void impl$useStoredException(Logger logger, String message, Object param) {
        logger.warn(message, param, (Object)this.impl$capturedException);
        this.impl$capturedException = null;
    }
}

