/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.level.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.UUIDCodec;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraft.world.storage.ServerWorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.accessor.world.level.LevelSettingsAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.level.dimension.LevelStemBridge;
import org.spongepowered.common.bridge.world.level.levelgen.WorldGenSettingsBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.data.fixer.LegacyUUIDCodec;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={ServerWorldInfo.class})
public abstract class PrimaryLevelDataMixin
implements IServerConfiguration,
PrimaryLevelDataBridge,
ResourceKeyBridge {
    @Shadow
    private WorldSettings field_237342_b_;
    @Shadow
    private int field_237345_e_;
    @Shadow
    private int field_237346_f_;
    @Shadow
    private int field_237347_g_;
    @Shadow
    private float field_242984_h;
    private @Nullable ResourceKey impl$key;
    private DimensionType impl$dimensionType;
    private @Nullable SerializationBehavior impl$serializationBehavior;
    private @Nullable Component impl$displayName;
    private @Nullable Integer impl$viewDistance;
    private UUID impl$uniqueId = UUID.randomUUID();
    private Boolean impl$pvp;
    private InheritableConfigHandle<WorldConfig> impl$configAdapter;
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private final List<UUID> impl$pendingUniqueIds = new ArrayList<UUID>();
    private int impl$trackedUniqueIdCount = 0;
    private boolean impl$customDifficulty = false;
    private boolean impl$customGameType = false;
    private boolean impl$customSpawnPosition = false;
    private boolean impl$loadOnStartup;
    private boolean impl$performsSpawnLogic;
    private BiMap<Integer, UUID> impl$mapUUIDIndex = HashBiMap.create();

    @Shadow
    public abstract boolean shadow$func_176123_z();

    @Shadow
    public abstract void shadow$func_176143_a(BlockPos var1, float var2);

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public boolean bridge$valid() {
        return this.impl$key != null;
    }

    @Override
    public @Nullable ServerWorld bridge$world() {
        if (!Sponge.isServerAvailable()) {
            return null;
        }
        ServerWorld world = SpongeCommon.server().func_71218_a(SpongeWorldManager.createRegistryKey(this.impl$key));
        if (world == null) {
            return null;
        }
        IServerWorldInfo levelData = (IServerWorldInfo)world.func_72912_H();
        if (levelData != this) {
            return null;
        }
        return world;
    }

    @Override
    public DimensionType bridge$dimensionType() {
        return this.impl$dimensionType;
    }

    @Override
    public void bridge$dimensionType(DimensionType type, boolean updatePlayers) {
        this.impl$dimensionType = type;
    }

    @Override
    public UUID bridge$uniqueId() {
        return this.impl$uniqueId;
    }

    @Override
    public void bridge$setUniqueId(UUID uniqueId) {
        this.impl$uniqueId = uniqueId;
    }

    @Override
    public boolean bridge$customDifficulty() {
        return this.impl$customDifficulty;
    }

    @Override
    public boolean bridge$customGameType() {
        return this.impl$customGameType;
    }

    @Override
    public boolean bridge$customSpawnPosition() {
        return this.impl$customSpawnPosition;
    }

    @Override
    public void bridge$forceSetDifficulty(Difficulty difficulty) {
        this.impl$customDifficulty = true;
        ((LevelSettingsAccessor)this.field_237342_b_).accessor$difficulty(difficulty);
        this.impl$updateWorldForDifficultyChange(this.bridge$world(), this.shadow$func_176123_z());
    }

    @Override
    public Optional<Boolean> bridge$pvp() {
        return Optional.ofNullable(this.impl$pvp);
    }

    @Override
    public void bridge$setPvp(@Nullable Boolean pvp) {
        this.impl$pvp = pvp;
    }

    @Override
    public boolean bridge$performsSpawnLogic() {
        return this.impl$performsSpawnLogic;
    }

    @Override
    public void bridge$setPerformsSpawnLogic(boolean performsSpawnLogic) {
        this.impl$performsSpawnLogic = performsSpawnLogic;
    }

    @Override
    public boolean bridge$loadOnStartup() {
        return this.impl$loadOnStartup;
    }

    @Override
    public void bridge$setLoadOnStartup(boolean loadOnStartup) {
        this.impl$loadOnStartup = loadOnStartup;
    }

    @Override
    public Optional<SerializationBehavior> bridge$serializationBehavior() {
        return Optional.ofNullable(this.impl$serializationBehavior);
    }

    @Override
    public void bridge$setSerializationBehavior(@Nullable SerializationBehavior behavior) {
        this.impl$serializationBehavior = behavior;
    }

    @Override
    public Optional<Component> bridge$displayName() {
        return Optional.ofNullable(this.impl$displayName);
    }

    @Override
    public void bridge$setDisplayName(@Nullable Component displayName) {
        this.impl$displayName = displayName;
    }

    @Override
    public Optional<Integer> bridge$viewDistance() {
        return Optional.ofNullable(this.impl$viewDistance);
    }

    @Override
    public void bridge$setViewDistance(@Nullable Integer viewDistance) {
        this.impl$viewDistance = viewDistance;
        ServerWorld world = this.bridge$world();
        if (world != null) {
            int actual = viewDistance == null ? BootstrapProperties.viewDistance : viewDistance;
            world.func_72863_F().func_217219_a(actual);
            SUpdateViewDistancePacket packet = new SUpdateViewDistancePacket(actual);
            world.func_217369_A().forEach(p -> p.field_71135_a.func_147359_a((IPacket)packet));
        }
    }

    @Override
    public InheritableConfigHandle<WorldConfig> bridge$configAdapter() {
        return this.impl$configAdapter;
    }

    @Override
    public void bridge$configAdapter(InheritableConfigHandle<WorldConfig> adapter) {
        this.impl$configAdapter = adapter;
    }

    @Override
    public void bridge$populateFromDimension(Dimension stem) {
        LevelStemBridge levelStemBridge = (LevelStemBridge)stem;
        this.impl$key = ((ResourceKeyBridge)stem).bridge$getKey();
        this.impl$dimensionType = stem.func_236063_b_();
        this.impl$displayName = levelStemBridge.bridge$displayName().orElse(null);
        levelStemBridge.bridge$difficulty().ifPresent(v -> {
            ((LevelSettingsAccessor)this.field_237342_b_).accessor$difficulty((Difficulty)RegistryTypes.DIFFICULTY.get().value((ResourceKey)v));
            this.impl$customDifficulty = true;
        });
        levelStemBridge.bridge$gameMode().ifPresent(v -> {
            ((LevelSettingsAccessor)this.field_237342_b_).accessor$gameType((GameType)RegistryTypes.GAME_MODE.get().value((ResourceKey)v));
            this.impl$customGameType = true;
        });
        levelStemBridge.bridge$spawnPosition().ifPresent(v -> {
            this.shadow$func_176143_a(VecHelper.toBlockPos(v), this.field_242984_h);
            this.impl$customSpawnPosition = true;
        });
        levelStemBridge.bridge$hardcore().ifPresent(v -> ((LevelSettingsAccessor)this.field_237342_b_).accessor$hardcode((boolean)v));
        this.impl$serializationBehavior = levelStemBridge.bridge$serializationBehavior().orElse(null);
        this.impl$pvp = levelStemBridge.bridge$pvp().orElse(null);
        this.impl$loadOnStartup = levelStemBridge.bridge$loadOnStartup();
        this.impl$performsSpawnLogic = levelStemBridge.bridge$performsSpawnLogic();
        this.impl$viewDistance = levelStemBridge.bridge$viewDistance().orElse(null);
    }

    @Override
    public void bridge$setMapUUIDIndex(BiMap<Integer, UUID> index) {
        this.impl$mapUUIDIndex = index;
    }

    @Override
    public BiMap<Integer, UUID> bridge$getMapUUIDIndex() {
        return this.impl$mapUUIDIndex;
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uuid) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uuid);
        if (index != null) {
            return index;
        }
        this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount, (Object)uuid);
        this.impl$pendingUniqueIds.add(uuid);
        return this.impl$trackedUniqueIdCount++;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable((UUID)this.impl$playerUniqueIdMap.get((Object)index));
    }

    public IServerWorldInfo func_230407_G_() {
        if (World.field_234918_g_.func_240901_a_().equals((Object)this.impl$key)) {
            return (IServerWorldInfo)this;
        }
        return (IServerWorldInfo)SpongeCommon.server().func_71218_a(World.field_234918_g_).func_72912_H();
    }

    @Redirect(method={"func_237370_a_(Lnet/minecraft/util/registry/DynamicRegistries;Lnet/minecraft/nbt/CompoundNBT;Lnet/minecraft/nbt/CompoundNBT;)V"}, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/serialization/Codec;encodeStart(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", ordinal=0))
    private DataResult<Object> impl$ignorePluginDimensionsWhenWritingWorldGenSettings(Codec codec, DynamicOps<Object> ops, Object input) {
        DimensionGeneratorSettings dimensionGeneratorSettings = (DimensionGeneratorSettings)input;
        if (dimensionGeneratorSettings.func_236224_e_().func_239659_c_().size() == 0) {
            return codec.encodeStart(ops, (Object)dimensionGeneratorSettings);
        }
        dimensionGeneratorSettings = ((WorldGenSettingsBridge)input).bridge$copy();
        SimpleRegistry registry = new SimpleRegistry(net.minecraft.util.registry.Registry.field_239700_af_, Lifecycle.stable());
        ((Registry)dimensionGeneratorSettings.func_236224_e_()).streamEntries().forEach(entry -> {
            if ("minecraft".equals(entry.key().namespace())) {
                ((Registry)registry).register(entry.key(), (Dimension)entry.value());
            }
        });
        ((DimensionGeneratorSettingsAccessor)dimensionGeneratorSettings).accessor$dimensions((SimpleRegistry<Dimension>)registry);
        return codec.encodeStart(ops, (Object)dimensionGeneratorSettings);
    }

    void impl$updateWorldForDifficultyChange(ServerWorld world, boolean isLocked) {
        if (world == null) {
            return;
        }
        MinecraftServer server = world.func_73046_m();
        Difficulty difficulty = ((IWorldInfo)this).func_176130_y();
        if (difficulty == Difficulty.HARD) {
            world.func_72891_a(true, true);
        } else if (server.func_71264_H()) {
            world.func_72891_a(difficulty != Difficulty.PEACEFUL, true);
        } else {
            world.func_72891_a(((MinecraftServerAccessor)server).invoker$isSpawningMonsters(), server.func_230537_U_());
        }
        world.func_217369_A().forEach(player -> player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(difficulty, isLocked)));
    }

    @Override
    public void bridge$readSpongeLevelData(Dynamic<INBT> dynamic) {
        if (dynamic == null) {
            this.bridge$setUniqueId(UUID.randomUUID());
            return;
        }
        this.bridge$setUniqueId(dynamic.get("UUID").read((Decoder)UUIDCodec.field_239775_a_).result().orElse(UUID.randomUUID()));
        List mapIndexList = dynamic.get("MapUUIDs").readMap((Decoder)Codec.STRING, (Decoder)UUIDCodec.field_239775_a_).result().orElse(Collections.emptyList());
        HashBiMap mapIndex = HashBiMap.create();
        for (Pair pair : mapIndexList) {
            int id = Integer.parseInt((String)pair.getFirst());
            mapIndex.put((Object)id, (Object)((UUID)pair.getSecond()));
        }
        this.bridge$setMapUUIDIndex((BiMap<Integer, UUID>)mapIndex);
        dynamic.get("PlayerIdTable").readList(LegacyUUIDCodec.CODEC).result().orElseGet(() -> dynamic.get("player-uuid-table").readList((Decoder)UUIDCodec.field_239775_a_).result().orElse(Collections.emptyList())).forEach(uuid -> {
            Integer playerIndex = (Integer)this.impl$playerUniqueIdMap.inverse().get(uuid);
            if (playerIndex == null) {
                this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount++, uuid);
            }
        });
    }

    @Override
    public CompoundNBT bridge$writeSpongeLevelData() {
        CompoundNBT data = new CompoundNBT();
        data.func_186854_a("UUID", this.bridge$uniqueId());
        CompoundNBT mapUUIDIndexTag = new CompoundNBT();
        MapUtil.saveMapUUIDIndex(mapUUIDIndexTag, this.bridge$getMapUUIDIndex());
        data.func_218657_a("MapUUIDs", (INBT)mapUUIDIndexTag);
        ListNBT playerIdList = new ListNBT();
        data.func_218657_a("player-uuid-table", (INBT)playerIdList);
        this.impl$pendingUniqueIds.forEach(uuid -> playerIdList.add((Object)new IntArrayNBT(UUIDCodec.func_239777_a_((UUID)uuid))));
        this.impl$pendingUniqueIds.clear();
        return data;
    }

    public String toString() {
        return new StringJoiner(", ", ServerWorldInfo.class.getSimpleName() + "[", "]").add("key=" + this.impl$key).add("worldType=" + this.impl$dimensionType).add("uniqueId=" + this.impl$uniqueId).add("spawn=" + new Vector3i(this.field_237345_e_, this.field_237346_f_, this.field_237347_g_)).add("gameType=" + ((IServerWorldInfo)this).func_76077_q()).add("hardcore=" + ((IWorldInfo)this).func_76093_s()).add("difficulty=" + ((IWorldInfo)this).func_176130_y()).toString();
    }
}

