/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.world.level.block;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.applaunch.config.common.CommonConfig;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.entitycollision.CollisionCapabilityBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.config.inheritable.EntityCollisionCategory;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

@Mixin(value={Block.class})
public abstract class BlockMixin_EntityCollision
implements CollisionCapabilityBridge {
    private int entityCollision$maxCollisions = 8;
    private boolean entityCollision$refreshCache = true;

    @Override
    public ResourceKey collision$getKey() {
        return Sponge.game().registry(RegistryTypes.BLOCK_TYPE).valueKey((BlockType)((Object)this));
    }

    @Override
    public int collision$getMaxCollisions() {
        return this.entityCollision$maxCollisions;
    }

    @Override
    public void collision$setMaxCollisions(int max) {
        this.entityCollision$maxCollisions = max;
    }

    @Override
    public void collision$requiresCollisionsCacheRefresh(boolean flag) {
        this.entityCollision$refreshCache = flag;
    }

    @Override
    public boolean collision$requiresCollisionsCacheRefresh() {
        return this.entityCollision$refreshCache;
    }

    @Override
    public void collision$initializeCollisionState(World world) {
        InheritableConfigHandle<WorldConfig> worldConfigAdapter = ((PrimaryLevelDataBridge)world.func_72912_H()).bridge$configAdapter();
        ConfigHandle<CommonConfig> globalConfigAdapter = SpongeConfigs.getCommon();
        EntityCollisionCategory worldCollCat = ((WorldConfig)worldConfigAdapter.get()).entityCollision;
        this.collision$setMaxCollisions(worldCollCat.maxEntitiesWithinAABB);
        boolean requiresSave = false;
        String[] ids = Sponge.game().registry(RegistryTypes.BLOCK_TYPE).valueKey((BlockType)((Object)this)).toString().split(":");
        String modId = ids[0];
        String name = ids[1];
        EntityCollisionCategory.ModSubCategory worldCollMod = worldConfigAdapter.getOrCreateValue(s2 -> s2.entityCollision.mods.get(modId), c -> {
            EntityCollisionCategory.ModSubCategory globalCollision = new EntityCollisionCategory.ModSubCategory(modId);
            c.entityCollision.mods.put(modId, globalCollision);
            globalCollision.blocks.put(name, this.collision$getMaxCollisions());
        }, worldCollCat.autoPopulate);
        if (worldCollMod != null) {
            Integer blockMaxCollision;
            if (!worldCollMod.enabled) {
                this.collision$setMaxCollisions(-1);
                return;
            }
            Integer modCollisionMax = worldCollMod.blockDefault;
            if (modCollisionMax != null) {
                this.collision$setMaxCollisions(modCollisionMax);
            }
            if ((blockMaxCollision = worldCollMod.blocks.get(name)) == null && worldCollCat.autoPopulate) {
                worldCollMod.blocks.put(name, this.collision$getMaxCollisions());
                requiresSave = true;
            } else if (blockMaxCollision != null) {
                this.collision$setMaxCollisions(blockMaxCollision);
            }
        }
        if (this.collision$getMaxCollisions() <= 0) {
            return;
        }
        if (requiresSave) {
            globalConfigAdapter.save();
        }
    }
}

