/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={ArmorStandEntity.class, MobEntity.class, PlayerEntity.class})
public abstract class TraitMixin_ArmorEquipable_Inventory_API
implements ArmorEquipable {
    @Override
    public boolean canEquip(EquipmentType type) {
        return true;
    }

    @Override
    public boolean canEquip(EquipmentType type, @Nullable ItemStack equipment) {
        return true;
    }

    @Override
    public Optional<ItemStack> equipped(EquipmentType type) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return Optional.of(ItemStackUtil.fromNative(lens.getSlotLens(type).getStack(fabric)));
    }

    @Override
    public boolean equip(EquipmentType type, @Nullable ItemStack equipment) {
        InventoryAdapter inv = ((InventoryBridge)((Object)this)).bridge$getAdapter();
        EquipmentInventoryLens lens = this.impl$equipmentInventory(inv);
        Fabric fabric = inv.inventoryAdapter$getFabric();
        return lens.getSlotLens(type).setStack(fabric, ItemStackUtil.toNative(equipment));
    }

    @Override
    public ItemStack itemInHand(HandType handType) {
        Preconditions.checkNotNull((Object)handType);
        net.minecraft.item.ItemStack nmsItem = ((LivingEntity)this).func_184586_b((Hand)handType);
        return ItemStackUtil.fromNative(nmsItem);
    }

    @Override
    public void setItemInHand(HandType handType, @Nullable ItemStack itemInHand) {
        Preconditions.checkNotNull((Object)handType);
        ((LivingEntity)this).func_184611_a((Hand)handType, ItemStackUtil.toNative(itemInHand).func_77946_l());
    }

    @Override
    public ItemStack head() {
        return this.equipped(EquipmentTypes.HEAD).get();
    }

    @Override
    public void setHead(ItemStack head) {
        this.equip(EquipmentTypes.HEAD, head);
    }

    @Override
    public ItemStack chest() {
        return this.equipped(EquipmentTypes.CHEST).get();
    }

    @Override
    public void setChest(ItemStack chest) {
        this.equip(EquipmentTypes.CHEST, chest);
    }

    @Override
    public ItemStack legs() {
        return this.equipped(EquipmentTypes.LEGS).get();
    }

    @Override
    public void setLegs(ItemStack legs) {
        this.equip(EquipmentTypes.LEGS, legs);
    }

    @Override
    public ItemStack feet() {
        return this.equipped(EquipmentTypes.FEET).get();
    }

    @Override
    public void setFeet(ItemStack feet) {
        this.equip(EquipmentTypes.FEET, feet);
    }

    private EquipmentInventoryLens impl$equipmentInventory(InventoryAdapter adapter) {
        Lens rootLens = adapter.inventoryAdapter$getRootLens();
        if (rootLens instanceof EquipmentInventoryLens) {
            return (EquipmentInventoryLens)rootLens;
        }
        if (rootLens instanceof PlayerInventoryLens) {
            return ((PlayerInventoryLens)rootLens).getEquipmentLens();
        }
        throw new IllegalStateException("Unexpected lens for Equipable Inventory " + rootLens.getClass().getName());
    }
}

