/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.inventory.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.IContainerListener;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.inventory.container.ContainerBridge;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.inventory.adapter.impl.DefaultImplementedAdapterInventory;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={net.minecraft.inventory.container.Container.class}, priority=998)
public abstract class ContainerMixin_Inventory_API
implements Container,
DefaultImplementedAdapterInventory.WithClear {
    @Shadow
    @Final
    private List<IContainerListener> field_75149_d;
    @Shadow
    @Final
    @Nullable
    private net.minecraft.inventory.container.ContainerType<?> field_216965_e;

    @Override
    public boolean isViewedSlot(Slot slot) {
        Set<net.minecraft.inventory.container.Slot> set;
        if (slot instanceof net.minecraft.inventory.container.Slot && (set = ((ContainerBridge)((Object)this)).bridge$getInventories().get(((net.minecraft.inventory.container.Slot)slot).field_75224_c)) != null && set.contains(slot)) {
            if (((ContainerBridge)((Object)this)).bridge$getInventories().size() == 1) {
                return true;
            }
            if (((net.minecraft.inventory.container.Slot)slot).field_75224_c.getClass() != PlayerInventory.class) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Inventory> viewed() {
        ArrayList<Inventory> list = new ArrayList<Inventory>();
        for (IInventory inv : ((ContainerBridge)((Object)this)).bridge$getInventories().keySet()) {
            Inventory inventory = InventoryUtil.toInventory(inv, null);
            list.add(inventory);
        }
        return list;
    }

    @Override
    public boolean setCursor(ItemStack item) {
        if (!this.isOpen()) {
            return false;
        }
        net.minecraft.item.ItemStack nativeStack = ItemStackUtil.toNative(item);
        this.listeners().stream().findFirst().ifPresent(p -> p.field_71071_by.func_70437_b(nativeStack));
        return true;
    }

    @Override
    public Optional<ItemStack> cursor() {
        return this.listeners().stream().findFirst().map(p -> p.field_71071_by.func_70445_o()).map(ItemStackUtil::fromNative);
    }

    @Override
    public ServerPlayer viewer() {
        return this.listeners().stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Container without viewer"));
    }

    @Override
    public boolean isOpen() {
        ContainerMixin_Inventory_API thisContainer = this;
        return this.viewer().openInventory().map(c -> c == thisContainer).orElse(false);
    }

    @Override
    public ContainerType type() {
        return (ContainerType)this.field_216965_e;
    }

    private List<ServerPlayerEntity> listeners() {
        return this.field_75149_d.stream().filter(ServerPlayerEntity.class::isInstance).map(ServerPlayerEntity.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<InventoryMenu> currentMenu() {
        return Optional.ofNullable(((MenuBridge)((Object)this)).bridge$getMenu());
    }
}

