/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.entity;

import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.entity.ChangeEntityEquipmentEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.comp.EquipmentInventoryLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_Inventory
extends Entity {
    @Shadow
    public abstract void shadow$func_184201_a(EquipmentSlotType var1, ItemStack var2);

    @Shadow
    protected abstract ItemStack shadow$func_241347_e_(EquipmentSlotType var1);

    @Shadow
    protected abstract ItemStack shadow$func_241346_d_(EquipmentSlotType var1);

    @Shadow
    protected abstract void shadow$func_71036_o();

    protected LivingEntityMixin_Inventory(EntityType<?> param0, World param1) {
        super(param0, param1);
    }

    @Inject(method={"func_241342_a_(Ljava/util/Map;)V"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerChunkProvider;func_217218_b(Lnet/minecraft/entity/Entity;Lnet/minecraft/network/IPacket;)V")})
    protected void inventory$onHandleHandSwap(Map<EquipmentSlotType, ItemStack> map, CallbackInfo ci) {
        Slot mainHand = this.impl$getSpongeSlot(EquipmentSlotType.MAINHAND);
        boolean customMainHand = this.impl$throwEquipmentEvent(EquipmentSlotType.MAINHAND, mainHand, map.get(EquipmentSlotType.MAINHAND), this.shadow$func_241347_e_(EquipmentSlotType.MAINHAND));
        Slot offHand = this.impl$getSpongeSlot(EquipmentSlotType.OFFHAND);
        boolean customOffHand = this.impl$throwEquipmentEvent(EquipmentSlotType.OFFHAND, offHand, map.get(EquipmentSlotType.OFFHAND), this.shadow$func_241347_e_(EquipmentSlotType.OFFHAND));
        if (customMainHand || customOffHand) {
            ci.cancel();
        }
    }

    @Inject(method={"func_241344_b_(Ljava/util/Map;)V"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V")})
    protected void inventory$onHandleEquipmentChanges(Map<EquipmentSlotType, ItemStack> map, CallbackInfo ci) {
        map.entrySet().removeIf(entry -> {
            Slot slotAdapter = this.impl$getSpongeSlot((EquipmentSlotType)entry.getKey());
            ItemStack oldStack = null;
            switch (((EquipmentSlotType)entry.getKey()).func_188453_a()) {
                case HAND: {
                    oldStack = this.shadow$func_241347_e_((EquipmentSlotType)entry.getKey());
                    break;
                }
                case ARMOR: {
                    oldStack = this.shadow$func_241346_d_((EquipmentSlotType)entry.getKey());
                }
            }
            return this.impl$throwEquipmentEvent((EquipmentSlotType)entry.getKey(), slotAdapter, (ItemStack)entry.getValue(), oldStack);
        });
    }

    @Redirect(method={"func_184608_ct()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;func_71036_o()V"))
    protected void inventory$onUpdateUsingItem(LivingEntity thisEntity) {
        this.shadow$func_71036_o();
    }

    private boolean impl$throwEquipmentEvent(EquipmentSlotType equipmentslottype, Slot slot, ItemStack newStack, ItemStack oldStack) {
        ChangeEntityEquipmentEvent event = InventoryEventFactory.callChangeEntityEquipmentEvent((LivingEntity)this, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack), slot);
        if (event.isCancelled()) {
            this.shadow$func_184201_a(equipmentslottype, oldStack);
            return true;
        }
        Transaction<@NonNull ItemStackSnapshot> transaction = event.transaction();
        if (!transaction.isValid()) {
            this.shadow$func_184201_a(equipmentslottype, oldStack);
            return true;
        }
        Optional<ItemStackSnapshot> optional = transaction.custom();
        if (optional.isPresent()) {
            ItemStack custom = ItemStackUtil.fromSnapshotToNative(optional.get());
            this.shadow$func_184201_a(equipmentslottype, custom);
            return true;
        }
        return false;
    }

    protected Slot impl$getSpongeSlot(EquipmentSlotType equipmentSlot) {
        EquipmentType equipmentType = (EquipmentType)equipmentSlot;
        if (this instanceof InventoryBridge) {
            InventoryAdapter adapter = ((InventoryBridge)((Object)this)).bridge$getAdapter();
            Lens lens = adapter.inventoryAdapter$getRootLens();
            if (lens instanceof EquipmentInventoryLens) {
                SlotLens slotLens = ((EquipmentInventoryLens)lens).getSlotLens(equipmentType);
                return slotLens.getAdapter(adapter.inventoryAdapter$getFabric(), (Inventory)((Object)adapter));
            }
            throw new IllegalStateException("Expected EquipmentInventoryLens for " + ((Object)((Object)this)).getClass().getName() + " Inventory but found: " + lens.getClass().getName());
        }
        throw new IllegalStateException("Living Entity has no InventoryAdapter: " + ((Object)((Object)this)).getClass().getName());
    }
}

