/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.server.level;

import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerInventoryBridge;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.mixin.inventory.event.entity.player.PlayerMixin_Inventory;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerMixin_Inventory
extends PlayerMixin_Inventory {
    private @Nullable EffectTransactor inventory$effectTransactor = null;
    private @Nullable Object inventory$menuProvider;

    ServerPlayerMixin_Inventory(EntityType<?> param0, World param1) {
        super(param0, param1);
    }

    @Override
    protected void impl$beforeSetItemSlot(EquipmentSlotType param0, ItemStack param1, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        this.inventory$effectTransactor = transactor.logPlayerInventoryChangeWithEffect((PlayerEntity)this, PlayerInventoryTransaction.EventCreator.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void impl$afterSetItemSlot(EquipmentSlotType param0, ItemStack param1, CallbackInfo ci) {
        try (EffectTransactor ignored = this.inventory$effectTransactor;){
            this.field_71069_bz.func_75142_b();
        }
        finally {
            this.inventory$effectTransactor = null;
        }
    }

    @Override
    protected void impl$beforeRemoveItem(boolean param0, CallbackInfoReturnable<Boolean> cir) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        this.inventory$effectTransactor = transactor.logDropFromPlayerInventory((ServerPlayerEntity)this, param0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void impl$onPlayerDrop(boolean param0, CallbackInfoReturnable<Boolean> cir) {
        try (EffectTransactor ignored = this.inventory$effectTransactor;){
            this.field_71070_bA.func_75142_b();
        }
        finally {
            this.inventory$effectTransactor = null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void inventory$switchToCloseWindowState(Container container, PlayerEntity player) {
        if (Sponge.isServerAvailable() && Sponge.isClientAvailable()) {
            container.func_75134_a(player);
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        try (@NonNull P ctx = ((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext(PhaseTracker.SERVER).source(serverPlayer)).packetPlayer(serverPlayer);){
            ((PhaseContext)ctx).buildAndSwitch();
            try (EffectTransactor ignored = ((PhaseContext)ctx).getTransactor().logCloseInventory(player, true);){
                container.func_75134_a(player);
                container.func_75142_b();
            }
        }
        this.impl$onCloseMenu();
    }

    @Override
    protected void inventory$onTouch(Entity entity, PlayerEntity player) {
        if (entity instanceof ItemEntity) {
            entity.func_70100_b_(player);
            return;
        }
        if (!((EntityBridge)entity).bridge$isPlayerTouchDeclared()) {
            entity.func_70100_b_(player);
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        try (EffectTransactor ignored = context.getTransactor().logPlayerInventoryChangeWithEffect(player, PlayerInventoryTransaction.EventCreator.STANDARD);){
            entity.func_70100_b_(player);
            this.field_71069_bz.func_75142_b();
        }
    }

    @Override
    protected void inventory$onHandleHandSwap(Map<EquipmentSlotType, ItemStack> map, CallbackInfo ci) {
    }

    @Override
    protected void inventory$onUpdateUsingItem(LivingEntity thisPlayer) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try (EffectTransactor ignored = transactor.logPlayerInventoryChangeWithEffect((PlayerEntity)((ServerPlayerEntity)this), PlayerInventoryTransaction.EventCreator.STANDARD);){
            this.shadow$func_71036_o();
            this.field_71069_bz.func_75142_b();
        }
    }

    @Inject(method={"func_213829_a(Lnet/minecraft/inventory/container/INamedContainerProvider;)Ljava/util/OptionalInt;"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/ServerPlayerEntity;field_71070_bA:Lnet/minecraft/inventory/container/Container;", opcode=181, shift=At.Shift.AFTER)})
    private void impl$afterOpenMenu(INamedContainerProvider param0, CallbackInfoReturnable<OptionalInt> cir) {
        PhaseTracker.SERVER.getPhaseContext().getTransactor().logContainerSet((PlayerEntity)((ServerPlayerEntity)this));
    }

    @Inject(method={"func_213829_a(Lnet/minecraft/inventory/container/INamedContainerProvider;)Ljava/util/OptionalInt;"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;func_75132_a(Lnet/minecraft/inventory/container/IContainerListener;)V")})
    private void impl$onOpenMenu(INamedContainerProvider $$0, CallbackInfoReturnable<OptionalInt> cir) {
        this.inventory$menuProvider = $$0;
        if (this.inventory$menuProvider instanceof ViewableInventoryBridge) {
            ((ViewableInventoryBridge)this.inventory$menuProvider).viewableBridge$addPlayer((ServerPlayerEntity)this);
        }
    }

    @Inject(method={"func_184826_a(Lnet/minecraft/entity/passive/horse/AbstractHorseEntity;Lnet/minecraft/inventory/IInventory;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;func_75132_a(Lnet/minecraft/inventory/container/IContainerListener;)V")})
    private void impl$onOpenHorseInventory(AbstractHorseEntity horse, IInventory inventoryIn, CallbackInfo ci) {
        this.inventory$menuProvider = inventoryIn;
        if (this.inventory$menuProvider instanceof ViewableInventoryBridge) {
            ((ViewableInventoryBridge)this.inventory$menuProvider).viewableBridge$addPlayer((ServerPlayerEntity)this);
        }
    }

    @Inject(method={"func_71128_l()V"}, at={@At(value="RETURN")})
    private void impl$onDoCloseContainer(CallbackInfo ci) {
        this.impl$onCloseMenu();
    }

    private void impl$onCloseMenu() {
        if (this.inventory$menuProvider instanceof ViewableInventoryBridge) {
            ((ViewableInventoryBridge)this.inventory$menuProvider).viewableBridge$removePlayer((ServerPlayerEntity)this);
        }
        this.inventory$menuProvider = null;
    }

    @Redirect(method={"func_213829_a(Lnet/minecraft/inventory/container/INamedContainerProvider;)Ljava/util/OptionalInt;"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/INamedContainerProvider;createMenu(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/inventory/container/Container;"))
    private Container impl$transactMenuCreationWithEffect(INamedContainerProvider menuProvider, int var1, PlayerInventory var2, PlayerEntity var3) {
        try (EffectTransactor ignored = PhaseTracker.SERVER.getPhaseContext().getTransactor().logOpenInventory((PlayerEntity)((ServerPlayerEntity)this));){
            Container container = menuProvider.createMenu(var1, var2, var3);
            return container;
        }
    }

    @Override
    protected Slot impl$getSpongeSlot(EquipmentSlotType equipmentSlot) {
        EquipmentType equipmentType = (EquipmentType)equipmentSlot;
        PlayerInventoryBridge inventory = (PlayerInventoryBridge)((ServerPlayerEntity)this).field_71071_by;
        Lens lens = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getRootLens();
        Fabric fabric = ((InventoryAdapter)((Object)inventory)).inventoryAdapter$getFabric();
        if (lens instanceof PlayerInventoryLens) {
            SlotLens slotLens = ((PlayerInventoryLens)lens).getEquipmentLens().getSlotLens(equipmentType);
            return slotLens.getAdapter(fabric, (Inventory)((Object)inventory));
        }
        throw new IllegalStateException("Unknown Lens for Player Inventory: " + lens.getClass().getName());
    }
}

