/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.NonNullList;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.InventoryMenuBridge;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.custom.SpongeInventoryMenu;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={net.minecraft.inventory.container.Container.class})
public abstract class AbstractContainerMenuMixin_Inventory
implements TrackedContainerBridge,
InventoryAdapter {
    @Final
    @Shadow
    private NonNullList<ItemStack> field_75153_a;
    @Final
    @Shadow
    public List<net.minecraft.inventory.container.Slot> field_75151_b;
    @Final
    @Shadow
    private List<IContainerListener> field_75149_d;
    @Final
    @Shadow
    private List<IntReferenceHolder> field_216964_d;
    private boolean impl$isClicking;
    private boolean impl$captureSuccess = false;

    @Shadow
    protected abstract ItemStack shadow$func_241440_b_(int var1, int var2, ClickType var3, PlayerEntity var4);

    @Override
    public boolean bridge$capturePossible() {
        return this.impl$captureSuccess;
    }

    @Redirect(method={"func_241440_b_(IILnet/minecraft/inventory/container/ClickType;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Slot;func_82869_a(Lnet/minecraft/entity/player/PlayerEntity;)Z", ordinal=0), slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/inventory/container/ClickType;THROW:Lnet/minecraft/inventory/container/ClickType;"), to=@At(value="FIELD", target="Lnet/minecraft/inventory/container/ClickType;PICKUP_ALL:Lnet/minecraft/inventory/container/ClickType;")))
    private boolean impl$verifyReadOnlyMenu(net.minecraft.inventory.container.Slot slot, PlayerEntity playerIn) {
        if (((LevelBridge)playerIn.field_70170_p).bridge$isFake()) {
            slot.func_82869_a(playerIn);
        }
        if (((MenuBridge)((Object)this)).bridge$isReadonlyMenu(slot)) {
            ((MenuBridge)((Object)this)).bridge$refreshListeners();
            return false;
        }
        return slot.func_82869_a(playerIn);
    }

    @Redirect(method={"func_241440_b_(IILnet/minecraft/inventory/container/ClickType;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;func_82846_b(Lnet/minecraft/entity/player/PlayerEntity;I)Lnet/minecraft/item/ItemStack;"))
    private ItemStack impl$transferStackInSlot(net.minecraft.inventory.container.Container thisContainer, PlayerEntity player, int slotId) {
        ItemStack result = thisContainer.func_82846_b(player, slotId);
        if (((LevelBridge)player.field_70170_p).bridge$isFake() || !(thisContainer.func_75139_a(slotId) instanceof CraftingResultSlot)) {
            return result;
        }
        this.bridge$detectAndSendChanges(true);
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TrackingUtil.processBlockCaptures(context);
        return result;
    }

    @Redirect(method={"func_184996_a(IILnet/minecraft/inventory/container/ClickType;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/inventory/container/Container;func_241440_b_(IILnet/minecraft/inventory/container/ClickType;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/item/ItemStack;"))
    private ItemStack inventory$wrapDoClickWithTransaction(net.minecraft.inventory.container.Container menu, int slotId, int dragType, ClickType clickType, PlayerEntity player) {
        if (((LevelBridge)player.field_70170_p).bridge$isFake()) {
            return this.shadow$func_241440_b_(slotId, dragType, clickType, player);
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        try {
            EffectTransactor ignored = transactor.logClickContainer(menu, slotId, dragType, clickType, player);
            try {
                this.impl$isClicking = true;
                ItemStack itemStack = this.shadow$func_241440_b_(slotId, dragType, clickType, player);
                if (ignored != null) {
                    ignored.close();
                }
                return itemStack;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.impl$isClicking = false;
        }
    }

    @Inject(method={"func_75142_b()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$broadcastChangesWithTransactions(CallbackInfo ci) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            return;
        }
        this.bridge$detectAndSendChanges(false);
        this.impl$captureSuccess = true;
        ci.cancel();
    }

    @Override
    public void bridge$detectAndSendChanges(boolean captureOnly) {
        SpongeInventoryMenu menu = ((MenuBridge)((Object)this)).bridge$getMenu();
        ArrayList<Integer> changes = new ArrayList<Integer>();
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            net.minecraft.inventory.container.Slot slot = this.field_75151_b.get(i);
            ItemStack newStack = slot.func_75211_c();
            ItemStack oldStack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changes.add(i);
        }
        for (Integer i : changes) {
            net.minecraft.inventory.container.Slot slot = this.field_75151_b.get(i);
            ItemStack newStack = slot.func_75211_c();
            ItemStack oldStack = (ItemStack)this.field_75153_a.get(i.intValue());
            if (this.impl$isClicking && menu != null && !menu.onChange(newStack, oldStack, (Container)((Object)this), i, slot)) {
                this.field_75153_a.set(i.intValue(), (Object)oldStack.func_77946_l());
                this.impl$sendSlotContents(i, oldStack);
                continue;
            }
            this.impl$capture(i, newStack, oldStack);
            if (captureOnly) continue;
            oldStack = newStack.func_190926_b() ? ItemStack.field_190927_a : newStack.func_77946_l();
            this.field_75153_a.set(i.intValue(), (Object)oldStack);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71111_a((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack);
            }
        }
        this.impl$detectAndSendPropertyChanges();
        if (this instanceof InventoryMenuBridge) {
            ((InventoryMenuBridge)((Object)this)).bridge$markClean();
        }
    }

    private void impl$sendSlotContents(Integer i, ItemStack oldStack) {
        for (IContainerListener listener : this.field_75149_d) {
            boolean isChangingQuantityOnly = true;
            if (listener instanceof ServerPlayerEntity) {
                isChangingQuantityOnly = ((ServerPlayerEntity)listener).field_71137_h;
                ((ServerPlayerEntity)listener).field_71137_h = false;
            }
            listener.func_71111_a((net.minecraft.inventory.container.Container)this, i.intValue(), oldStack);
            if (!(listener instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)listener).field_71137_h = isChangingQuantityOnly;
        }
    }

    private void impl$detectAndSendPropertyChanges() {
        for (int j = 0; j < this.field_216964_d.size(); ++j) {
            IntReferenceHolder intreferenceholder = this.field_216964_d.get(j);
            if (!intreferenceholder.func_221496_c()) continue;
            for (IContainerListener icontainerlistener1 : this.field_75149_d) {
                icontainerlistener1.func_71112_a((net.minecraft.inventory.container.Container)this, j, intreferenceholder.func_221495_b());
            }
        }
    }

    private void impl$capture(Integer index, ItemStack newStack, ItemStack oldStack) {
        PhaseContext<?> phaseContext = PhaseTracker.SERVER.getPhaseContext();
        if (PhaseTracker.SERVER.onSidedThread() && !phaseContext.isRestoring() && !(phaseContext instanceof TileEntityTickContext)) {
            ItemStackSnapshot oldItem = ItemStackUtil.snapshotOf(oldStack);
            ItemStackSnapshot newItem = ItemStackUtil.snapshotOf(newStack);
            try {
                Slot adapter = this.inventoryAdapter$getSlot(index).get();
                SlotTransaction newTransaction = new SlotTransaction(adapter, oldItem, newItem);
                phaseContext.getTransactor().logSlotTransaction(phaseContext, newTransaction, (net.minecraft.inventory.container.Container)this);
            }
            catch (IndexOutOfBoundsException e) {
                SpongeCommon.logger().error("SlotIndex out of LensBounds! Did the Container change after creation?", (Throwable)e);
            }
        }
    }
}

