/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.event.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryTypes;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;

@Mixin(value={CraftingResultSlot.class})
public abstract class ResultSlotMixin_Inventory
extends Slot {
    @Shadow
    @Final
    private PlayerEntity field_75238_b;
    @Shadow
    private int field_75237_g;
    @Shadow
    @Final
    private net.minecraft.inventory.CraftingInventory field_75239_a;
    @Nullable
    private CraftingRecipe impl$onTakeRecipe;
    @Nullable
    private ItemStack impl$craftedStack;
    private int impl$craftedStackQuantity;

    public ResultSlotMixin_Inventory(IInventory inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public void func_75215_d(@Nullable ItemStack stack) {
        super.func_75215_d(stack);
        if (this.field_75238_b instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)this.field_75238_b).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, 0, stack));
        }
    }

    @Inject(method={"func_75208_c(Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private void impl$beforeCrafting(ItemStack itemStack, CallbackInfo ci) {
        this.impl$craftedStackQuantity = this.field_75237_g;
    }

    @Inject(method={"func_190901_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"}, at={@At(value="HEAD")})
    private void impl$beforeTake(PlayerEntity thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        if (this.impl$onTakeRecipe == null || !((IRecipe)this.impl$onTakeRecipe).func_77569_a((IInventory)this.field_75239_a, thePlayer.field_70170_p)) {
            this.impl$onTakeRecipe = thePlayer.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.field_75239_a, thePlayer.field_70170_p).orElse(null);
        }
        stack.func_190917_f(1);
        this.impl$craftedStack = stack.func_77946_l();
        if (this.field_75237_g != 0) {
            this.impl$craftedStackQuantity = this.field_75237_g;
        }
        this.impl$craftedStack.func_190920_e(this.impl$craftedStackQuantity);
        stack.func_190918_g(1);
    }

    @Redirect(method={"func_190901_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/crafting/RecipeManager;func_215369_c(Lnet/minecraft/item/crafting/IRecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Lnet/minecraft/util/NonNullList;"))
    private <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> impl$onGetRemainingItems(RecipeManager recipeManager, IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        if (this.impl$onTakeRecipe == null) {
            return NonNullList.func_191197_a((int)inventoryIn.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        return worldIn.func_199532_z().func_215369_c(recipeTypeIn, inventoryIn, worldIn);
    }

    @Inject(method={"func_190901_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;"}, cancellable=true, at={@At(value="RETURN")})
    private void impl$afterTake(PlayerEntity thePlayer, ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        if (((LevelBridge)thePlayer.field_70170_p).bridge$isFake()) {
            return;
        }
        Container container = thePlayer.field_71070_bA;
        Inventory craftInv = ((Inventory)container).query(QueryTypes.INVENTORY_TYPE.get().of(CraftingInventory.class));
        if (!(craftInv instanceof CraftingInventory)) {
            SpongeCommon.logger().warn("Detected crafting without a InventoryCrafting!? Crafting Event will not fire.");
            return;
        }
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        TransactionalCaptureSupplier transactor = context.getTransactor();
        transactor.logCrafting(thePlayer, this.impl$craftedStack, (CraftingInventory)craftInv, this.impl$onTakeRecipe);
        this.impl$craftedStack = null;
    }
}

