/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.entity;

import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;

@Mixin(value={Entity.class}, priority=1500)
public abstract class EntityMixin_Optimization_Collision {
    @Inject(method={"func_145775_I()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$checkForNeighboringChunkIfAvailable(CallbackInfo ci) {
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || !activeChunk.bridge$areNeighborsLoaded() || activeChunk.bridge$isQueuedForUnload()) {
            ci.cancel();
        }
    }

    @Redirect(method={"func_145775_I()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_175707_a(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean activeCollision$ignoreWorldIsAreaLoaded(World world, BlockPos from, BlockPos to) {
        return true;
    }

    @Inject(method={"func_210500_b(Lnet/minecraft/tags/ITag;D)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$BailIfNeighborsAreInactive(ITag<Fluid> p_210500_1_, double p_201500_2_, CallbackInfoReturnable<Boolean> cir) {
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || activeChunk.bridge$isQueuedForUnload() || !activeChunk.bridge$areNeighborsLoaded()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"func_210500_b(Lnet/minecraft/tags/ITag;D)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;func_217344_a(IIIIII)Z"))
    private boolean activeCollision$IgnoreAreaIsLoaded(World world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (((LevelBridge)world).bridge$isFake()) {
            return world.func_217344_a(xStart, yStart, zStart, xEnd, yEnd, zEnd);
        }
        return true;
    }
}

