/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.plugin.entityactivation;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.explosive.fused.FusedExplosive;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.phys.AABBAccessor;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.activation.ActivationCapabilityBridge;
import org.spongepowered.common.bridge.world.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.EntityActivationRangeCategory;
import org.spongepowered.common.config.inheritable.GlobalConfig;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;

public final class EntityActivationRange {
    private static final ImmutableMap<Byte, String> activationTypeMappings = new ImmutableMap.Builder().put((Object)1, (Object)"monster").put((Object)2, (Object)"creature").put((Object)3, (Object)"aquatic").put((Object)4, (Object)"ambient").put((Object)5, (Object)"misc").build();
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB miscBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB creatureBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB monsterBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB aquaticBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB ambientBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static AxisAlignedBB tileEntityBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    static Map<Byte, Integer> maxActivationRanges = new HashMap<Byte, Integer>();

    public static byte initializeEntityActivationType(Entity entity) {
        if (entity instanceof IMob) {
            return 1;
        }
        if (entity instanceof AnimalEntity) {
            return 2;
        }
        if (entity instanceof WaterMobEntity) {
            return 3;
        }
        if (entity instanceof AmbientEntity) {
            return 4;
        }
        return 5;
    }

    public static void initializeEntityActivationState(Entity entity) {
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        if (entity instanceof PlayerEntity && !((PlatformEntityBridge)entity).bridge$isFakePlayer() || entity instanceof ThrowableEntity || entity instanceof EnderDragonEntity || entity instanceof EnderDragonPartEntity || entity instanceof WitherEntity || entity instanceof DamagingProjectileEntity || entity instanceof LightningBoltEntity || entity instanceof TNTEntity || entity instanceof PaintingEntity || entity instanceof EnderCrystalEntity || entity instanceof FireworkRocketEntity || entity instanceof FallingBlockEntity) {
            return;
        }
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.getForWorld(entity.field_70170_p);
        EntityActivationRangeCategory config = ((WorldConfig)configAdapter.get()).entityActivationRange;
        EntityTypeBridge type = (EntityTypeBridge)entity.func_200600_R();
        ResourceLocation key = EntityType.func_200718_a((EntityType)entity.func_200600_R());
        byte activationType = spongeEntity.activation$getActivationType();
        String activationTypeName = (String)activationTypeMappings.getOrDefault((Object)activationType, (Object)"misc");
        if (!type.bridge$isActivationRangeInitialized()) {
            EntityActivationRange.addEntityToConfig(config.autoPopulate, key, activationType, activationTypeName);
            type.bridge$setActivationRangeInitialized(true);
        }
        EntityActivationRangeCategory.ModSubCategory entityMod = config.mods.get(key.func_110624_b());
        int defaultActivationRange = config.globalRanges.get(activationTypeName);
        if (entityMod == null) {
            spongeEntity.activation$setActivationRange(defaultActivationRange);
            if (defaultActivationRange > 0) {
                spongeEntity.activation$setDefaultActivationState(false);
            }
        } else {
            if (!entityMod.enabled) {
                spongeEntity.activation$setDefaultActivationState(true);
                return;
            }
            Integer defaultModActivationRange = entityMod.defaultRanges.get(activationTypeName);
            Integer entityActivationRange = entityMod.entities.get(key.func_110623_a());
            if (defaultModActivationRange != null && entityActivationRange == null) {
                spongeEntity.activation$setActivationRange(defaultModActivationRange);
                if (defaultModActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            } else if (entityActivationRange != null) {
                spongeEntity.activation$setActivationRange(entityActivationRange);
                if (entityActivationRange > 0) {
                    spongeEntity.activation$setDefaultActivationState(false);
                }
            }
        }
    }

    public static AxisAlignedBB growBb(AxisAlignedBB target, AxisAlignedBB source, int x, int y, int z) {
        ((AABBAccessor)target).accessor$setMinX(source.field_72340_a - (double)x);
        ((AABBAccessor)target).accessor$setMinY(source.field_72338_b - (double)y);
        ((AABBAccessor)target).accessor$setMinZ(source.field_72339_c - (double)z);
        ((AABBAccessor)target).accessor$setMaxX(source.field_72336_d + (double)x);
        ((AABBAccessor)target).accessor$setMaxY(source.field_72337_e + (double)y);
        ((AABBAccessor)target).accessor$setMaxZ(source.field_72334_f + (double)z);
        return target;
    }

    public static void activateEntities(net.minecraft.world.server.ServerWorld world) {
        if (((LevelBridge)world).bridge$isFake()) {
            return;
        }
        for (ServerPlayerEntity player : world.func_217369_A()) {
            int maxRange = 0;
            for (Integer range : maxActivationRanges.values()) {
                if (range <= maxRange) continue;
                maxRange = range;
            }
            maxRange = Math.min((((ServerWorld)world).properties().viewDistance() << 4) - 8, maxRange);
            ((ActivationCapabilityBridge)player).activation$setActivatedTick(SpongeCommon.server().func_71259_af());
            AxisAlignedBB aabb = maxBB;
            EntityActivationRange.growBb(aabb, player.func_174813_aQ(), maxRange, 256, maxRange);
            int i = MathHelper.func_76128_c((double)(aabb.field_72340_a / 16.0));
            int j = MathHelper.func_76128_c((double)(aabb.field_72336_d / 16.0));
            int k = MathHelper.func_76128_c((double)(aabb.field_72339_c / 16.0));
            int l = MathHelper.func_76128_c((double)(aabb.field_72334_f / 16.0));
            for (int i1 = i; i1 <= j; ++i1) {
                for (int j1 = k; j1 <= l; ++j1) {
                    Chunk chunk = world.func_72863_F().func_225313_a(i1, j1);
                    if (chunk == null) continue;
                    EntityActivationRange.activateChunkEntities((PlayerEntity)player, chunk);
                }
            }
        }
    }

    private static void activateChunkEntities(PlayerEntity player, Chunk chunk) {
        for (ClassInheritanceMultiMap entitySection : chunk.func_177429_s()) {
            for (Entity entity : entitySection) {
                AxisAlignedBB aabb;
                ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
                long currentTick = SpongeCommon.server().func_71259_af();
                if (!((TrackableBridge)entity).bridge$shouldTick() || currentTick <= spongeEntity.activation$getActivatedTick()) continue;
                if (spongeEntity.activation$getDefaultActivationState()) {
                    spongeEntity.activation$setActivatedTick(currentTick);
                    continue;
                }
                if (spongeEntity.activation$requiresActivationCacheRefresh()) {
                    EntityActivationRange.initializeEntityActivationState(entity);
                    spongeEntity.activation$requiresActivationCacheRefresh(false);
                }
                switch (spongeEntity.activation$getActivationType()) {
                    case 5: {
                        aabb = miscBB;
                        break;
                    }
                    case 4: {
                        aabb = ambientBB;
                        break;
                    }
                    case 3: {
                        aabb = aquaticBB;
                        break;
                    }
                    case 2: {
                        aabb = creatureBB;
                        break;
                    }
                    default: {
                        aabb = monsterBB;
                    }
                }
                int bbActivationRange = spongeEntity.activation$getActivationRange();
                EntityActivationRange.growBb(aabb, player.func_174813_aQ(), bbActivationRange, 256, bbActivationRange);
                if (!aabb.func_72326_a(entity.func_174813_aQ())) continue;
                spongeEntity.activation$setActivatedTick(currentTick);
            }
        }
    }

    public static boolean checkEntityImmunities(Entity entity) {
        if (entity.func_70090_H() || ((EntityAccessor)entity).accessor$remainingFireTicks() > 0) {
            return true;
        }
        if (!(entity instanceof Projectile) ? !entity.func_184188_bt().isEmpty() || entity.func_184187_bx() != null : !entity.func_233570_aj_()) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.field_70737_aN > 0 || living.func_70651_bq().size() > 0) {
                return true;
            }
            if (entity instanceof MobEntity && ((LivingEntity)entity).func_70643_av() != null || ((LivingEntity)entity).func_110144_aD() != null) {
                return true;
            }
            if (entity instanceof VillagerEntity && ((VillagerEntity)entity).func_213743_em()) {
                return true;
            }
            if (entity instanceof AnimalEntity) {
                AnimalEntity animal = (AnimalEntity)entity;
                if (animal.func_70631_g_() || animal.func_70880_s()) {
                    return true;
                }
                if (entity instanceof SheepEntity && ((SheepEntity)entity).func_70892_o()) {
                    return true;
                }
            }
            return entity instanceof FusedExplosive && ((FusedExplosive)entity).get(Keys.IS_PRIMED).orElse(false) != false;
        }
        return false;
    }

    public static boolean checkIfActive(Entity entity) {
        boolean isActive;
        if (entity instanceof PlayerEntity || entity.field_70170_p.func_201670_d() || !entity.field_70175_ag || entity instanceof FireworkRocketEntity) {
            return true;
        }
        LevelChunkBridge activeChunk = ((ActiveChunkReferantBridge)entity).bridge$getActiveChunk();
        if (activeChunk == null) {
            return true;
        }
        if (!activeChunk.bridge$isActive()) {
            return false;
        }
        if (activeChunk.bridge$isPersistedChunk() || ((PlatformEntityBridge)entity).bridge$isFakePlayer() && entity instanceof ServerPlayerEntity) {
            return true;
        }
        long currentTick = SpongeCommon.server().func_71259_af();
        ActivationCapabilityBridge spongeEntity = (ActivationCapabilityBridge)entity;
        boolean bl = isActive = spongeEntity.activation$getActivatedTick() >= currentTick || spongeEntity.activation$getDefaultActivationState();
        if (!isActive) {
            if ((currentTick - spongeEntity.activation$getActivatedTick() - 1L) % 20L == 0L) {
                if (EntityActivationRange.checkEntityImmunities(entity)) {
                    spongeEntity.activation$setActivatedTick(currentTick + 20L);
                }
                isActive = true;
            }
        } else if (!spongeEntity.activation$getDefaultActivationState() && entity.field_70173_aa % 4 == 0 && !EntityActivationRange.checkEntityImmunities(entity)) {
            isActive = false;
        }
        if (isActive && !activeChunk.bridge$areNeighborsLoaded()) {
            isActive = false;
        }
        return isActive;
    }

    public static void addEntityToConfig(boolean autoPopulate, ResourceLocation key, byte activationType, String activationTypeName) {
        Integer defaultRange;
        InheritableConfigHandle<GlobalConfig> globalConfig = SpongeGameConfigs.getGlobalInheritable();
        EntityActivationRangeCategory activationConfig = ((GlobalConfig)globalConfig.get()).entityActivationRange;
        boolean requiresSave = false;
        Integer range = defaultRange = activationConfig.globalRanges.getOrDefault(activationTypeName, 32);
        EntityActivationRangeCategory.ModSubCategory modSubCategory = activationConfig.mods.get(key.func_110624_b());
        if (autoPopulate && modSubCategory == null) {
            modSubCategory = new EntityActivationRangeCategory.ModSubCategory();
            activationConfig.mods.put(key.func_110624_b(), modSubCategory);
            requiresSave = true;
        }
        if (modSubCategory != null) {
            Integer modActivationRange = modSubCategory.defaultRanges.get(activationTypeName);
            if (autoPopulate && modActivationRange == null) {
                modSubCategory.defaultRanges.put(activationTypeName, defaultRange);
                requiresSave = true;
            } else if (modActivationRange != null && modActivationRange > range) {
                range = modActivationRange;
            }
            Integer entityActivationRange = modSubCategory.entities.get(key.func_110623_a());
            if (autoPopulate && entityActivationRange == null) {
                modSubCategory.entities.put(key.func_110623_a(), modSubCategory.defaultRanges.get(activationTypeName));
                requiresSave = true;
            }
            if (entityActivationRange != null && entityActivationRange > range) {
                range = entityActivationRange;
            }
        }
        int newRange = range;
        maxActivationRanges.compute(activationType, (k, maxRange) -> maxRange == null || newRange > maxRange ? newRange : maxRange);
        if (autoPopulate && requiresSave) {
            globalConfig.save();
        }
    }
}

