/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={Entity.class, TileEntity.class})
public abstract class CreatorTrackedMixin_Tracker
implements CreatorTrackedBridge {
    private @Nullable UUID tracker$creator;
    private @Nullable UUID tracker$notifier;

    @Override
    public Optional<UUID> tracker$getCreatorUUID() {
        return Optional.ofNullable(this.tracker$creator);
    }

    @Override
    public Optional<UUID> tracker$getNotifierUUID() {
        return Optional.ofNullable(this.tracker$notifier);
    }

    @Override
    public void tracker$setTrackedUUID(PlayerTracker.Type type, @Nullable UUID uuid) {
        if (PlayerTracker.Type.CREATOR == type) {
            this.tracker$creator = uuid;
            if (uuid == null) {
                ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.CREATOR);
            } else {
                ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.CREATOR, uuid);
            }
        } else if (PlayerTracker.Type.NOTIFIER == type) {
            this.tracker$notifier = uuid;
            if (uuid == null) {
                ((SpongeDataHolderBridge)((Object)this)).bridge$remove(Keys.NOTIFIER);
            } else {
                ((SpongeDataHolderBridge)((Object)this)).bridge$offer(Keys.NOTIFIER, uuid);
            }
        }
    }

    private @Nullable UUID getTrackedUniqueId(PlayerTracker.Type type) {
        if (this.tracker$creator != null && PlayerTracker.Type.CREATOR == type) {
            return this.tracker$creator;
        }
        if (this instanceof TameableEntity) {
            TameableEntity ownable = (TameableEntity)this;
            LivingEntity owner = ownable.func_70902_q();
            if (owner instanceof PlayerEntity) {
                this.tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, owner.func_110124_au());
                return owner.func_110124_au();
            }
        } else if (this.tracker$notifier != null && PlayerTracker.Type.NOTIFIER == type) {
            return this.tracker$notifier;
        }
        return null;
    }
}

