/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server;

import java.util.function.BooleanSupplier;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.event.tracking.CauseTrackerCrashHandler;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.DelayedTaskPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.event.tracking.phase.tick.ServerTickState;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.WorldTickState;
import org.spongepowered.common.mixin.tracker.util.thread.BlockableEventLoopMixin_Tracker;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin_Tracker
extends BlockableEventLoopMixin_Tracker {
    @Shadow
    public abstract boolean shadow$func_71241_aa();

    @Shadow
    protected abstract void shadow$func_71190_q(BooleanSupplier var1);

    @Inject(method={"func_71230_b(Lnet/minecraft/crash/CrashReport;)Lnet/minecraft/crash/CrashReport;"}, at={@At(value="RETURN")}, cancellable=true)
    private void tracker$addPhaseTrackerToCrashReport(CrashReport report, CallbackInfoReturnable<CrashReport> cir) {
        report.func_85058_a("Sponge PhaseTracker").func_189529_a("Phase Stack", (ICrashReportDetail)CauseTrackerCrashHandler.INSTANCE);
        cir.setReturnValue((Object)report);
    }

    @Inject(method={"func_71217_p(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="RETURN")})
    private void tracker$ensurePhaseTrackerEmpty(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        PhaseTracker.SERVER.ensureEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_71217_p(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;func_71190_q(Ljava/util/function/BooleanSupplier;)V"))
    private void tracker$wrapUpdateTimeLightAndEntities(MinecraftServer minecraftServer, BooleanSupplier hasTimeLeft) {
        try (@NonNull ServerTickState.ServerTickContext context = TickPhase.Tick.SERVER_TICK.createPhaseContext(PhaseTracker.SERVER).server(minecraftServer);){
            context.buildAndSwitch();
            this.shadow$func_71190_q(hasTimeLeft);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_71190_q(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_72835_b(Ljava/util/function/BooleanSupplier;)V"))
    private void tracker$wrapWorldTick(ServerWorld serverWorld, BooleanSupplier hasTimeLeft) {
        try (@NonNull WorldTickState.WorldTickContext context = TickPhase.Tick.WORLD_TICK.createPhaseContext(PhaseTracker.SERVER).world(serverWorld);){
            context.buildAndSwitch();
            serverWorld.func_72835_b(hasTimeLeft);
        }
    }

    @Inject(method={"func_212875_d_(Ljava/lang/Runnable;)Lnet/minecraft/util/concurrent/TickDelayedTask;"}, at={@At(value="RETURN")})
    private void tracker$associatePhaseContextWithWrappedTask(Runnable runnable, CallbackInfoReturnable<TickDelayedTask> cir) {
        TickDelayedTask returnValue = (TickDelayedTask)cir.getReturnValue();
        if (!PhaseTracker.SERVER.onSidedThread()) {
            PhaseContext<@NonNull ?> phaseContext = PhaseTracker.getInstance().getPhaseContext();
            if (phaseContext.isEmpty()) {
                return;
            }
            phaseContext.foldContextForThread((TickTaskBridge)returnValue);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_213166_h(Lnet/minecraft/util/concurrent/TickDelayedTask;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/concurrent/RecursiveEventLoop;func_213166_h(Ljava/lang/Runnable;)V"))
    private void tracker$wrapAndPerformContextSwitch(RecursiveEventLoop<?> thisServer, Runnable runnable) {
        try (@NonNull DelayedTaskPhaseState.Context context = ((DelayedTaskPhaseState.Context)PluginPhase.State.DELAYED_TASK.createPhaseContext(PhaseTracker.SERVER).source(runnable)).setDelayedContextPopulator(((TickTaskBridge)((Object)runnable)).bridge$getFrameModifier().orElse(null));){
            context.buildAndSwitch();
            super.shadow$func_213166_h(runnable);
        }
    }

    @Override
    protected boolean tracker$isServerAndIsServerStopped() {
        return this.shadow$func_71241_aa();
    }
}

