/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import net.minecraft.entity.Entity;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkLoadContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.util.PrettyPrinter;

@Mixin(value={ChunkManager.class})
public abstract class ChunkMapMixin_Tracker {
    @Shadow
    @Final
    private net.minecraft.world.server.ServerWorld field_219255_i;

    @Redirect(method={"func_219210_a(Lnet/minecraft/entity/Entity;)V"}, at=@At(value="NEW", args={"class=java/lang/IllegalStateException"}, remap=false))
    private IllegalStateException tracker$reportEntityAlreadyTrackedWithWorld(String string, Entity entityIn) {
        IllegalStateException exception = new IllegalStateException(String.format("Entity %s is already tracked for world: %s", entityIn, ((ServerWorld)this.field_219255_i).key()));
        if (SpongeConfigs.getCommon().get().phaseTracker.verboseErrors) {
            PhasePrinter.printMessageWithCaughtException(PhaseTracker.getInstance(), "Exception tracking entity", "An entity that was already tracked was added to the tracker!", exception);
        }
        return exception;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_222955_c_(Lnet/minecraft/world/chunk/IChunk;)Lnet/minecraft/world/chunk/Chunk;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;func_222879_B()V"))
    private static void tracker$wrapUnpackTicks(Chunk chunk) {
        if (!PhaseTracker.SERVER.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Unpacking").centre().hr().addWrapped("Someone is attempting to unpack chunk scheduled updates while off the main thread, this isgenerally unsupported and Sponge would appreciate a report about this. Please attach the generated classes output as a zip file after enabling -Dmixin.debug.export=true and request triage support on discord. Do NOT report as an issue on GitHub.", new Object[0]).add().add(" %s : %s", "Chunk Pos", chunk.func_76632_l().toString()).add().add(new Exception("Async Chunk Scheduling Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_LOADING) {
            return;
        }
        try (@NonNull ChunkLoadContext ctx = ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.getInstance()).source(chunk)).world((net.minecraft.world.server.ServerWorld)chunk.func_177412_p())).chunk(chunk);){
            ctx.buildAndSwitch();
            chunk.func_222879_B();
        }
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;func_217318_w()V"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;func_217314_a(Ljava/util/function/Supplier;)V"), to=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_147448_a(Ljava/util/Collection;)V")))
    private void tracker$startLoad(Chunk chunk) {
        chunk.func_217318_w();
        boolean isFake = ((LevelBridge)chunk.func_177412_p()).bridge$isFake();
        if (isFake) {
            return;
        }
        if (!PhaseTracker.SERVER.onSidedThread()) {
            new PrettyPrinter(60).add("Illegal Async Chunk Load").centre().hr().addWrapped("Sponge relies on knowing when chunks are being loaded as chunks add entities to the parented world for management. These operations are generally not threadsafe and shouldn't be considered a \"Sponge bug \". Adding/removing entities from another thread to the world is never ok.", new Object[0]).add().add(" %s : %s", "Chunk Pos", chunk.func_76632_l().toString()).add().add(new Exception("Async Chunk Load Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
            return;
        }
        ((ChunkLoadContext)((ChunkLoadContext)GenerationPhase.State.CHUNK_LOADING.createPhaseContext(PhaseTracker.getInstance()).source(chunk)).world((net.minecraft.world.server.ServerWorld)chunk.func_177412_p())).chunk(chunk).buildAndSwitch();
    }

    @Inject(method={"*"}, at={@At(value="INVOKE", remap=false, target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V", shift=At.Shift.BY, by=2)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;func_217318_w()V"))}, expect=1, require=1)
    private void tracker$endLoad(ChunkHolder chunkHolder, IChunk chunk, CallbackInfoReturnable<IChunk> cir) {
        if (!((LevelBridge)this.field_219255_i).bridge$isFake() && PhaseTracker.SERVER.onSidedThread()) {
            if (PhaseTracker.getInstance().getCurrentState() == GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING) {
                return;
            }
            PhaseTracker.getInstance().getPhaseContext().close();
        }
    }
}

