/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.level;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.PistonBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.apache.logging.log4j.Level;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.TickNextTickDataBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToLoadedListInWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToTickableListEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddTileEntityToWorldWhileProcessingEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyClientEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.NotifyNeighborSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PerformBlockDropsFromDestruction;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromChunkEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RemoveTileEntityFromWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ReplaceTileEntityInWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.TileOnLoadDuringAddToWorldEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateConnectingBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateLightSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateWorldRendererEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldDestroyBlockLevelEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.TileEntityPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;
import org.spongepowered.common.event.tracking.phase.generation.DeferredScheduledUpdatePhaseState;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.mixin.tracker.world.level.LevelMixin_Tracker;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerLevelMixin_Tracker
extends LevelMixin_Tracker
implements TrackedWorldBridge {
    @Shadow
    @Final
    private List<ServerPlayerEntity> field_217491_A;

    @Inject(method={"func_217484_g(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void tracker$setEntityUntrackedInWorld(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (!this.bridge$isFake()) {
            ((TrackableBridge)entityIn).bridge$markEntityRemovedFromLevel();
        }
    }

    @Redirect(method={"func_72835_b(Ljava/util/function/BooleanSupplier;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;func_217390_a(Ljava/util/function/Consumer;Lnet/minecraft/entity/Entity;)V"), slice=@Slice(from=@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;func_76320_a(Ljava/lang/String;)V", args={"ldc=tick"}), to=@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;func_76320_a(Ljava/lang/String;)V", args={"ldc=remove"})))
    private void tracker$wrapNormalEntityTick(net.minecraft.world.server.ServerWorld level, Consumer<net.minecraft.entity.Entity> entityUpdateConsumer, net.minecraft.entity.Entity entity) {
        PhaseContext<@NonNull ?> currentState = PhaseTracker.SERVER.getPhaseContext();
        TrackingUtil.tickEntity(entityUpdateConsumer, entity);
    }

    @Override
    protected void tracker$wrapBlockEntityTick(ITickableTileEntity blockEntity) {
        TrackingUtil.tickTileEntity(this, blockEntity);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_205338_b(Lnet/minecraft/world/NextTickListEntry;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;func_227033_a_(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockTick(net.minecraft.block.BlockState blockState, net.minecraft.world.server.ServerWorld worldIn, BlockPos posIn, Random randomIn, NextTickListEntry<Block> entry) {
        if (((TickNextTickDataBridge)entry).bridge$isPartOfWorldGeneration()) {
            try (@NonNull DeferredScheduledUpdatePhaseState.Context context = ((DeferredScheduledUpdatePhaseState.Context)GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE.createPhaseContext(PhaseTracker.SERVER).source(this)).scheduledUpdate(entry);){
                context.buildAndSwitch();
                blockState.func_227033_a_(worldIn, posIn, randomIn);
            }
            return;
        }
        TrackingUtil.updateTickBlock(this, blockState, posIn, randomIn);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Redirect(method={"func_205339_a(Lnet/minecraft/world/NextTickListEntry;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/fluid/FluidState;func_206880_a(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"))
    private void tracker$wrapFluidTick(FluidState fluidState, World worldIn, BlockPos pos, NextTickListEntry<Fluid> entry) {
        if (((TickNextTickDataBridge)entry).bridge$isPartOfWorldGeneration()) {
            try (@NonNull DeferredScheduledUpdatePhaseState.Context context = ((DeferredScheduledUpdatePhaseState.Context)GenerationPhase.State.DEFERRED_SCHEDULED_UPDATE.createPhaseContext(PhaseTracker.SERVER).source(this)).scheduledUpdate(entry);){
                context.buildAndSwitch();
                fluidState.func_206880_a(worldIn, pos);
            }
            return;
        }
        TrackingUtil.updateTickFluid(this, fluidState, pos);
    }

    @Redirect(method={"func_217441_a(Lnet/minecraft/world/chunk/Chunk;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;func_227034_b_(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapBlockRandomTick(net.minecraft.block.BlockState blockState, net.minecraft.world.server.ServerWorld worldIn, BlockPos posIn, Random randomIn) {
        TrackingUtil.randomTickBlock(this, blockState, posIn, this.field_73012_v);
    }

    @Redirect(method={"func_217441_a(Lnet/minecraft/world/chunk/Chunk;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/fluid/FluidState;func_206891_b(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"))
    private void tracker$wrapFluidRandomTick(FluidState fluidState, World worldIn, BlockPos pos, Random random) {
        TrackingUtil.randomTickFluid(this, fluidState, pos, this.field_73012_v);
    }

    @Inject(method={"func_217441_a(Lnet/minecraft/world/chunk/Chunk;I)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;func_76320_a(Ljava/lang/String;)V", args={"ldc=thunder"})})
    private void tracker$startWeatherTickPhase(Chunk param0, int param1, CallbackInfo ci) {
        ((PhaseContext)TickPhase.Tick.WEATHER.createPhaseContext(PhaseTracker.SERVER)).buildAndSwitch();
    }

    @Inject(method={"func_217441_a(Lnet/minecraft/world/chunk/Chunk;I)V"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/profiler/IProfiler;func_219895_b(Ljava/lang/String;)V", args={"ldc=tickBlocks"})})
    private void tracker$closeWeatherTickPhase(Chunk param0, int param1, CallbackInfo ci) {
        PhaseContext<@NonNull ?> context = PhaseTracker.SERVER.getPhaseContext();
        if (context.getState() != TickPhase.Tick.WEATHER) {
            throw new IllegalStateException("Expected to be in a Weather ticking state, but we aren't.");
        }
        context.close();
    }

    @Redirect(method={"func_147485_a(Lnet/minecraft/block/BlockEventData;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;func_235728_a_(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;II)Z"))
    private boolean tracker$wrapBlockStateEventReceived(net.minecraft.block.BlockState recievingState, World thisWorld, BlockPos targetPos, int eventId, int flag, BlockEventData data) {
        return TrackingUtil.fireMinecraftBlockEvent((net.minecraft.world.server.ServerWorld)this, data, recievingState);
    }

    @Redirect(method={"func_175641_c(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;II)V"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;add(Ljava/lang/Object;)Z", remap=false))
    private boolean tracker$associatePhaseContextDataWithBlockEvent(ObjectLinkedOpenHashSet<BlockEventData> list, Object data, BlockPos pos, Block blockIn, int eventID, int eventParam) {
        PhaseContext<@NonNull ?> currentContext = PhaseTracker.getInstance().getPhaseContext();
        BlockEventData blockEventData = (BlockEventData)data;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)blockEventData;
        if (currentContext.ignoresBlockEvent()) {
            return list.add((Object)blockEventData);
        }
        net.minecraft.block.BlockState state = this.shadow$func_180495_p(pos);
        if (((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            blockEvent.bridge$setSourceUserUUID(currentContext.getActiveUserUUID());
            if (((BlockStateBridge)state).bridge$hasTileEntity()) {
                blockEvent.bridge$setTileEntity((BlockEntity)this.shadow$func_175625_s(pos));
            }
            if (blockEvent.bridge$getTileEntity() == null) {
                LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)this)).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
                blockEvent.bridge$setTickingLocatable(locatable);
            }
        }
        if (!((TrackableBridge)blockIn).bridge$allowsBlockEventCreation()) {
            return list.add((Object)((BlockEventData)data));
        }
        currentContext.appendNotifierToBlockEvent(this, pos, blockEvent);
        if (ShouldFire.CHANGE_BLOCK_EVENT_PRE && (blockIn instanceof PistonBlock ? SpongeCommonEventFactory.handlePistonEvent(this, pos, state, eventID) : SpongeCommonEventFactory.callChangeBlockEventPre((ServerLevelBridge)((Object)this), pos).isCancelled())) {
            return false;
        }
        currentContext.getTransactor().logBlockEvent(state, this, pos, blockEvent);
        return list.add((Object)blockEventData);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Explosion tracker$triggerInternalExplosion(org.spongepowered.api.world.explosion.Explosion explosion, Function<? super Explosion, ? extends PhaseContext<@NonNull ?>> contextCreator) {
        Explosion mcExplosion;
        Explosion originalExplosion = (Explosion)explosion;
        if (ShouldFire.EXPLOSION_EVENT_PRE) {
            ExplosionEvent.Pre event = SpongeEventFactory.createExplosionEventPre(PhaseTracker.SERVER.currentCause(), explosion, (ServerWorld)((Object)this));
            if (SpongeCommon.post(event)) {
                return (Explosion)explosion;
            }
            explosion = event.explosion();
        }
        try {
            mcExplosion = (Explosion)explosion;
        }
        catch (Exception e) {
            new org.spongepowered.asm.util.PrettyPrinter(60).add("Explosion not compatible with this implementation").centre().hr().add("An explosion that was expected to be used for this implementation does not").add("originate from this implementation.").add((Throwable)e).trace();
            return originalExplosion;
        }
        try (@NonNull ? ignored = contextCreator.apply((Explosion)mcExplosion).source(explosion.sourceExplosive().orElse((Explosive)((Object)this)));){
            ((PhaseContext)ignored).buildAndSwitch();
            boolean damagesTerrain = explosion.shouldBreakBlocks();
            mcExplosion.func_77278_a();
            mcExplosion.func_77279_a(true);
            if (!damagesTerrain) {
                mcExplosion.func_180342_d();
            }
            for (ServerPlayerEntity playerEntity : this.field_217491_A) {
                Vector3d knockback = (Vector3d)mcExplosion.func_77277_b().get(playerEntity);
                if (knockback == null) continue;
                playerEntity.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(playerEntity.func_145782_y(), new Vector3d(knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c)));
            }
        }
        return mcExplosion;
    }

    @Override
    public Optional<WorldPipeline.Builder> bridge$startBlockChange(BlockPos pos, net.minecraft.block.BlockState newState, int flags) {
        if (World.func_189509_E((BlockPos)pos)) {
            return Optional.empty();
        }
        if (this.shadow$func_234925_Z_()) {
            return Optional.empty();
        }
        if (this.bridge$isFake()) {
            return Optional.empty();
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        Chunk chunk = this.shadow$func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return Optional.empty();
        }
        net.minecraft.block.BlockState currentState = chunk.func_180495_p(pos);
        return Optional.of(this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, 512));
    }

    private WorldPipeline.Builder bridge$makePipeline(BlockPos pos, net.minecraft.block.BlockState currentState, net.minecraft.block.BlockState newState, Chunk chunk, SpongeBlockChangeFlag spongeFlag, int limit) {
        TrackedLevelChunkBridge mixinChunk = (TrackedLevelChunkBridge)chunk;
        ChunkPipeline chunkPipeline = mixinChunk.bridge$createChunkPipeline(pos, newState, currentState, spongeFlag, limit);
        WorldPipeline.Builder worldPipelineBuilder = WorldPipeline.builder(chunkPipeline);
        worldPipelineBuilder.addEffect((pipeline, oldState, newState1, flag1, cursorLimit) -> {
            if (oldState == null) {
                return EffectResult.NULL_RETURN;
            }
            return EffectResult.NULL_PASS;
        }).addEffect(UpdateLightSideEffect.getInstance()).addEffect(CheckBlockPostPlacementIsSameEffect.getInstance()).addEffect(UpdateWorldRendererEffect.getInstance()).addEffect(NotifyClientEffect.getInstance()).addEffect(NotifyNeighborSideEffect.getInstance()).addEffect(UpdateConnectingBlocksEffect.getInstance());
        return worldPipelineBuilder;
    }

    @Override
    public boolean func_241211_a_(BlockPos pos, net.minecraft.block.BlockState newState, int flags, int limit) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        if (this.shadow$func_234925_Z_()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.func_241211_a_(pos, newState, flags, limit);
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(flags);
        Chunk chunk = this.shadow$func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        net.minecraft.block.BlockState currentState = chunk.func_180495_p(pos);
        if (currentState == newState) {
            return false;
        }
        WorldPipeline pipeline = this.bridge$makePipeline(pos, currentState, newState, chunk, spongeFlag, limit).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, newState, pos, null, spongeFlag, limit);
    }

    @Override
    public boolean func_241212_a_(BlockPos pos, boolean doDrops, @Nullable net.minecraft.entity.Entity p_241212_3_, int limit) {
        net.minecraft.block.BlockState currentState = this.shadow$func_180495_p(pos);
        if (currentState.func_196958_f()) {
            return false;
        }
        if (this.bridge$isFake()) {
            return super.func_241212_a_(pos, doDrops, p_241212_3_, limit);
        }
        PhaseTracker instance = PhaseTracker.getInstance();
        if (instance.getSidedThread() != PhaseTracker.SERVER.getSidedThread() && instance != PhaseTracker.SERVER) {
            throw new UnsupportedOperationException("Cannot perform a tracked Block Change on a ServerWorld while not on the main thread!");
        }
        FluidState fluidstate = this.shadow$func_204610_c(pos);
        net.minecraft.block.BlockState emptyBlock = fluidstate.func_206883_i();
        SpongeBlockChangeFlag spongeFlag = BlockChangeFlagManager.fromNativeInt(3);
        Chunk chunk = this.shadow$func_175726_f(pos);
        if (chunk.func_76621_g()) {
            return false;
        }
        WorldPipeline.Builder pipelineBuilder = this.bridge$makePipeline(pos, currentState, emptyBlock, chunk, spongeFlag, limit).addEffect(WorldDestroyBlockLevelEffect.getInstance());
        if (doDrops) {
            pipelineBuilder.addEffect(PerformBlockDropsFromDestruction.getInstance());
        }
        WorldPipeline pipeline = pipelineBuilder.addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
        return pipeline.processEffects(instance.getPhaseContext(), currentState, emptyBlock, pos, p_241212_3_, spongeFlag, limit);
    }

    @Override
    public SpongeBlockSnapshot bridge$createSnapshot(net.minecraft.block.BlockState state, BlockPos pos, BlockChangeFlag updateFlag) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world((net.minecraft.world.server.ServerWorld)this).position(VecHelper.toVector3i(pos));
        Chunk chunk = this.shadow$func_175726_f(pos);
        if (chunk == null) {
            return builder.flag(updateFlag).build();
        }
        Optional<UUID> creator = ((LevelChunkBridge)chunk).bridge$getBlockCreatorUUID(pos);
        Optional<UUID> notifier = ((LevelChunkBridge)chunk).bridge$getBlockNotifierUUID(pos);
        creator.ifPresent(builder::creator);
        notifier.ifPresent(builder::notifier);
        boolean hasTileEntity = ((BlockStateBridge)state).bridge$hasTileEntity();
        TileEntity tileEntity = chunk.func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        if ((hasTileEntity || tileEntity != null) && tileEntity != null) {
            CompoundNBT nbt = new CompoundNBT();
            try {
                tileEntity.func_189515_b(nbt);
                builder.addUnsafeCompound(nbt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        builder.flag(updateFlag);
        return builder.build();
    }

    @Override
    public void shadow$func_175713_t(BlockPos pos) {
        BlockPos immutable = pos.func_185334_h();
        TileEntity tileentity = this.shadow$func_175625_s(immutable);
        if (tileentity == null) {
            return;
        }
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$func_175713_t(immutable);
            return;
        }
        PhaseContext<@NonNull ?> current = PhaseTracker.SERVER.getPhaseContext();
        if (current.getTransactor().logTileRemoval(tileentity, () -> (net.minecraft.world.server.ServerWorld)this)) {
            TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(RemoveTileEntityFromWorldEffect.getInstance()).addEffect(RemoveTileEntityFromChunkEffect.getInstance()).build();
            pipeline.processEffects(current, new PipelineCursor(tileentity.func_195044_w(), 0, immutable, tileentity, null, 512));
            return;
        }
        super.shadow$func_175713_t(immutable);
    }

    @Override
    public boolean shadow$func_175700_a(TileEntity tileEntity) {
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            return super.shadow$func_175700_a(tileEntity);
        }
        PhaseContext<@NonNull ?> current = PhaseTracker.SERVER.getPhaseContext();
        if (current.doesBlockEventTracking()) {
            IChunk iChunk;
            BlockPos immutable = tileEntity.func_174877_v().func_185334_h();
            if (tileEntity.func_145831_w() != (net.minecraft.world.server.ServerWorld)this) {
                tileEntity.func_226984_a_((World)((net.minecraft.world.server.ServerWorld)this), immutable);
            }
            if (!((iChunk = this.shadow$func_217353_a(immutable.func_177958_n() >> 4, immutable.func_177952_p() >> 4, ChunkStatus.field_222617_m, false)) instanceof Chunk)) {
                return super.shadow$func_175700_a(tileEntity);
            }
            Chunk chunk = this.shadow$func_175726_f(immutable);
            if (current.getTransactor().logTileAddition(tileEntity, () -> (net.minecraft.world.server.ServerWorld)this, chunk)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(AddTileEntityToWorldWhileProcessingEffect.getInstance()).addEffect(AddTileEntityToLoadedListInWorldEffect.getInstance()).addEffect(AddTileEntityToTickableListEffect.getInstance()).addEffect(TileOnLoadDuringAddToWorldEffect.getInstance()).build();
                return pipeline.processEffects(current, new PipelineCursor(tileEntity.func_195044_w(), 0, immutable, tileEntity, null, 512));
            }
        }
        return super.shadow$func_175700_a(tileEntity);
    }

    @Override
    public void shadow$func_175690_a(BlockPos pos, @Nullable TileEntity proposed) {
        PhaseContext<?> current;
        BlockPos immutable = pos.func_185334_h();
        if (this.bridge$isFake() || PhaseTracker.SERVER.getSidedThread() != Thread.currentThread()) {
            super.shadow$func_175690_a(pos, proposed);
            return;
        }
        if (proposed != null) {
            if (proposed.func_145831_w() != (net.minecraft.world.server.ServerWorld)this) {
                proposed.func_226984_a_((World)((net.minecraft.world.server.ServerWorld)this), immutable);
            } else {
                proposed.func_174878_a(pos);
            }
        }
        if ((current = PhaseTracker.SERVER.getPhaseContext()).doesBlockEventTracking()) {
            @Nullable TileEntity existing = this.shadow$func_175726_f(immutable).func_175625_s(immutable);
            if (current.getTransactor().logTileReplacement(immutable, existing, proposed, () -> (net.minecraft.world.server.ServerWorld)this)) {
                TileEntityPipeline pipeline = TileEntityPipeline.kickOff((net.minecraft.world.server.ServerWorld)this, immutable).addEffect(RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect.getInstance()).addEffect(ReplaceTileEntityInWorldEffect.getInstance()).build();
                pipeline.processEffects(current, new PipelineCursor(proposed.func_195044_w(), 0, immutable, proposed, null, 512));
                return;
            }
        }
        super.shadow$func_175690_a(immutable, proposed);
    }

    @Override
    public void shadow$func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPos immutableTarget = pos.func_185334_h();
        BlockPos immutableFrom = fromPos.func_185334_h();
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            new PrettyPrinter(60).add("Illegal Async PhaseTracker Access").centre().hr().addWrapped("Sponge adapts the vanilla handling of various processes, such as setting a block or spawning an entity. Sponge is designed around the concept that Minecraft is primarily performing these operations on the \"server thread\". Because of this Sponge is safeguarding common access to the PhaseTracker as the entrypoint for performing these sort of changes.", new Object[0]).add().add(new Exception("Async Block Notifcation Detected")).log(SpongeCommon.logger(), Level.ERROR);
            return;
        }
        if (this.bridge$isFake()) {
            super.shadow$func_190524_a(immutableTarget, blockIn, immutableFrom);
            return;
        }
        Chunk targetChunk = this.shadow$func_175726_f(immutableTarget);
        net.minecraft.block.BlockState targetBlockState = targetChunk.func_180495_p(immutableTarget);
        if (!((TrackableBlockBridge)targetBlockState.func_177230_c()).bridge$overridesNeighborNotificationLogic()) {
            return;
        }
        PhaseContext<@NonNull ?> peek = server.getPhaseContext();
        try {
            Supplier<net.minecraft.world.server.ServerWorld> worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier((net.minecraft.world.server.ServerWorld)this, "ServerWorld");
            @Nullable TileEntity existingTile = targetChunk.func_177424_a(immutableTarget, Chunk.CreateEntityType.CHECK);
            peek.getTransactor().logNeighborNotification(worldSupplier, immutableFrom, blockIn, immutableTarget, targetBlockState, existingTile);
            peek.associateNeighborStateNotifier(immutableFrom, targetBlockState.func_177230_c(), immutableTarget, (net.minecraft.world.server.ServerWorld)this, PlayerTracker.Type.NOTIFIER);
            targetBlockState.func_215697_a((World)((net.minecraft.world.server.ServerWorld)this), immutableTarget, blockIn, immutableFrom, false);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception while updating neighbours");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
            crashreportcategory.func_189529_a("Source block type", () -> {
                try {
                    return String.format("ID #%d (%s // %s)", Registry.field_212618_g.func_148757_b((Object)blockIn), blockIn.func_149739_a(), blockIn.getClass().getCanonicalName());
                }
                catch (Throwable var2) {
                    return "ID #" + Registry.field_212618_g.func_148757_b((Object)blockIn);
                }
            });
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)immutableTarget, (net.minecraft.block.BlockState)targetBlockState);
            throw new ReportedException(crashreport);
        }
    }

    @Inject(method={"func_72838_d(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;func_226277_ct_()D")}, cancellable=true)
    private void tracker$throwPreEventAndRecord(net.minecraft.entity.Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        if (this.bridge$isFake()) {
            return;
        }
        PhaseTracker tracker = PhaseTracker.SERVER;
        if (tracker.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> current = tracker.getPhaseContext();
        if (!current.doesAllowEntitySpawns()) {
            cir.setReturnValue((Object)false);
            return;
        }
        try (CauseStackManager.StackFrame frame = tracker.pushCauseFrame();){
            ArrayList<Entity> entities = new ArrayList<Entity>();
            entities.add((Entity)entityIn);
            frame.addContext(EventContextKeys.SPAWN_TYPE, current.getSpawnTypeForTransaction(entityIn));
            SpawnEntityEvent.Pre pre = SpongeEventFactory.createSpawnEntityEventPre(frame.currentCause(), entities);
            Sponge.eventManager().post(pre);
            if (pre.isCancelled() || entities.isEmpty()) {
                cir.setReturnValue((Object)false);
                return;
            }
        }
        if (current.allowsBulkEntityCaptures()) {
            current.getTransactor().logEntitySpawn(current, this, entityIn);
        }
    }
}

