/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.entity;

import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.DelegatingConfigTrackableBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.world.entity.TrackableEntityBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;

@Mixin(value={Entity.class})
public abstract class EntityMixin_Tracker
implements DelegatingConfigTrackableBridge,
TrackableEntityBridge {
    @Shadow
    @Final
    private EntityType<?> field_200606_g;
    @Shadow
    public World field_70170_p;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    @Final
    protected Random field_70146_Z;
    private @Nullable Cause tracker$destructCause;
    protected @MonotonicNonNull EffectTransactor tracker$dropsTransactor = null;

    @Shadow
    public abstract @Nullable Team func_96124_cp();

    @Shadow
    public abstract UUID shadow$func_110124_au();

    @Shadow
    public abstract double shadow$func_226280_cw_();

    @Shadow
    public abstract double shadow$func_226277_ct_();

    @Shadow
    public abstract double shadow$func_226278_cu_();

    @Shadow
    public abstract double shadow$func_226281_cx_();

    @Shadow
    public abstract void shadow$func_70106_y();

    @Inject(method={"func_70099_a(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/ItemEntity;"}, at={@At(value="HEAD")})
    private void tracker$logEntityDropTransactionIfNecessary(ItemStack stack, float offsetY, CallbackInfoReturnable<ItemEntity> cir) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((LevelBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor == null) {
            this.tracker$dropsTransactor = context.getTransactor().ensureEntityDropTransactionEffect((Entity)this);
        }
    }

    @Inject(method={"func_70106_y()V"}, at={@At(value="RETURN")})
    private void tracker$ensureDropEffectCompleted(CallbackInfo ci) {
        PhaseTracker instance = PhaseTracker.SERVER;
        if (!instance.onSidedThread()) {
            return;
        }
        if (((LevelBridge)this.field_70170_p).bridge$isFake()) {
            return;
        }
        PhaseContext<@NonNull ?> context = instance.getPhaseContext();
        if (!context.doesBlockEventTracking()) {
            return;
        }
        if (this.tracker$dropsTransactor != null) {
            this.tracker$dropsTransactor.close();
        }
    }

    @Override
    public void bridge$markEntityRemovedFromLevel() {
        if (this.tracker$destructCause != null && ShouldFire.DESTRUCT_ENTITY_EVENT) {
            Audience originalChannel = Audience.empty();
            SpongeCommon.post(SpongeEventFactory.createDestructEntityEvent(this.tracker$destructCause, originalChannel, Optional.of(originalChannel), (Component)Component.empty(), (Component)Component.empty(), (org.spongepowered.api.entity.Entity)((Object)this), false));
            this.tracker$destructCause = null;
        }
    }

    @Override
    public void tracker$populateFrameInTickContext(CauseStackManager.StackFrame frame, EntityTickContext context) {
        this.tracker$populateDeathContextIfNeeded(frame, context);
    }

    protected void tracker$populateDeathContextIfNeeded(CauseStackManager.StackFrame frame, EntityTickContext context) {
    }

    @Inject(method={"func_70106_y()V"}, at={@At(value="RETURN")})
    private void impl$createDestructionEventOnDeath(CallbackInfo ci) {
        if (ShouldFire.DESTRUCT_ENTITY_EVENT && !((LevelBridge)this.field_70170_p).bridge$isFake()) {
            if (!((Entity)this instanceof LivingEntity)) {
                this.tracker$destructCause = PhaseTracker.getCauseStackManager().currentCause();
            } else if ((Entity)this instanceof ArmorStandEntity) {
                SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((ArmorStandEntity)this), null);
            }
        }
    }

    @Override
    public TrackableBridge bridge$trackingConfigDelegate() {
        return (TrackableBridge)this.field_200606_g;
    }
}

