/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.RegistryBackedTrackableBridge;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.tracker.TrackerCategory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.util.ReflectionUtil;

@Mixin(value={Block.class})
public abstract class BlockMixin_Tracker
implements TrackableBlockBridge,
RegistryBackedTrackableBridge<Block> {
    private final boolean tracker$hasNeighborLogicOverridden = ReflectionUtil.isNeighborChangedDeclared(this.getClass());
    private final boolean tracker$hasEntityInsideLogicOverridden = ReflectionUtil.isEntityInsideDeclared(this.getClass());
    private static @Nullable EffectTransactor tracker$effectTransactorForDrops = null;

    @Override
    public boolean bridge$overridesNeighborNotificationLogic() {
        return this.tracker$hasNeighborLogicOverridden;
    }

    @Override
    public boolean bridge$hasEntityInsideLogic() {
        return this.tracker$hasEntityInsideLogicOverridden;
    }

    @Inject(method={"func_220075_c(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "func_220059_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "func_220054_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void tracker$cancelOnBlockRestoration(CallbackInfo ci) {
        if (Thread.currentThread() == PhaseTracker.SERVER.getSidedThread() && PhaseTracker.SERVER.getPhaseContext().isRestoring()) {
            ci.cancel();
        }
    }

    @Inject(method={"func_220075_c(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, World worldIn, BlockPos pos, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(worldIn, pos, state, null);
    }

    @Inject(method={"func_220059_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, IWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntity, CallbackInfo ci) {
        if (!(worldIn instanceof World)) {
            return;
        }
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops((World)worldIn, pos, state, tileEntity);
    }

    @Inject(method={"func_220054_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="HEAD")})
    private static void tracker$captureBlockProposedToBeSpawningDrops(BlockState state, World worldIn, BlockPos pos, @Nullable TileEntity tileEntity, Entity entity, ItemStack itemStack, CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        tracker$effectTransactorForDrops = context.getTransactor().logBlockDrops(worldIn, pos, state, tileEntity);
    }

    @Inject(method={"func_220075_c(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", "func_220059_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;)V", "func_220054_a(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/entity/Entity;Lnet/minecraft/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private static void tracker$closeEffectIfCapturing(CallbackInfo ci) {
        PhaseTracker server = PhaseTracker.SERVER;
        if (server.getSidedThread() != Thread.currentThread()) {
            return;
        }
        PhaseContext<@NonNull ?> context = server.getPhaseContext();
        context.getTransactor().completeBlockDrops(tracker$effectTransactorForDrops);
    }

    @Override
    public TrackerCategory bridge$trackerCategory() {
        return SpongeGameConfigs.getTracker().get().block;
    }

    @Override
    public Registry<Block> bridge$trackerRegistryBacking() {
        return Registry.field_212618_g;
    }

    @Override
    public void bridge$saveTrackerConfig() {
        SpongeGameConfigs.getTracker().save();
    }
}

