/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={DispenserBlock.class})
public abstract class DispenserBlockMixin_Tracker {
    private Supplier<ItemStack> tracker$originalItem = () -> ItemStack.field_190927_a;
    private PhaseContext<?> tracker$context = PhaseContext.empty();

    @Inject(method={"func_176439_d(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="HEAD")})
    private void tracker$createContextOnDispensing(ServerWorld worldIn, BlockPos pos, CallbackInfo ci) {
        BlockState state = worldIn.func_180495_p(pos);
        SpongeBlockSnapshot spongeBlockSnapshot = ((TrackedWorldBridge)worldIn).bridge$createSnapshot(state, pos, BlockChangeFlags.ALL);
        LevelChunkBridge mixinChunk = (LevelChunkBridge)worldIn.func_175726_f(pos);
        this.tracker$context = ((PhaseContext)((PhaseContext)((PhaseContext)((PhaseContext)BlockPhase.State.DISPENSE.createPhaseContext(PhaseTracker.SERVER)).source(spongeBlockSnapshot)).creator(() -> mixinChunk.bridge$getBlockCreatorUUID(pos))).notifier(() -> mixinChunk.bridge$getBlockNotifierUUID(pos))).buildAndSwitch();
    }

    @Inject(method={"func_176439_d(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="RETURN")})
    private void tracker$closeContextOnDispensing(ServerWorld worldIn, BlockPos pos, CallbackInfo ci) {
        this.tracker$context.close();
        this.tracker$context = PhaseContext.empty();
    }

    @Inject(method={"func_176439_d(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/dispenser/IDispenseItemBehavior;dispense(Lnet/minecraft/dispenser/IBlockSource;Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/dispenser/IDispenseItemBehavior;field_223216_a_:Lnet/minecraft/dispenser/IDispenseItemBehavior;"), to=@At(value="TAIL"))}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void tracker$storeOriginalItem(ServerWorld worldIn, BlockPos pos, CallbackInfo ci, ProxyBlockSource source, DispenserTileEntity dispenser, int slotIndex, ItemStack dispensedItem, IDispenseItemBehavior behavior) {
        ItemStack tracker$originalItem = ItemStackUtil.cloneDefensiveNative(dispensedItem);
        this.tracker$originalItem = () -> tracker$originalItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"func_176439_d(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/DispenserTileEntity;func_70299_a(ILnet/minecraft/item/ItemStack;)V"))
    private void tracker$setInventoryContentsCallEvent(DispenserTileEntity dispenserTileEntity, int index, ItemStack stack) {
        ItemStack dispensedItem = ItemStack.field_190927_a;
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(dispensedItem);
        ArrayList<ItemStackSnapshot> original = new ArrayList<ItemStackSnapshot>();
        original.add(snapshot);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(dispenserTileEntity);
            DropItemEvent.Pre dropEvent = SpongeEventFactory.createDropItemEventPre(frame.currentCause(), (List<ItemStackSnapshot>)ImmutableList.of((Object)snapshot), original);
            SpongeCommon.post(dropEvent);
            if (dropEvent.isCancelled()) {
                dispenserTileEntity.func_70299_a(index, this.tracker$originalItem.get());
                return;
            }
            dispenserTileEntity.func_70299_a(index, stack);
        }
        finally {
            this.tracker$originalItem = () -> ItemStack.field_190927_a;
        }
    }
}

