/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world.level.chunk.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={ChunkSerializer.class})
public abstract class ChunkSerializerMixin_Tracker {
    @Inject(method={"func_222645_a(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/IChunk;)Lnet/minecraft/nbt/CompoundNBT;"}, at={@At(value="RETURN")})
    private static void impl$writeSpongeLevelData(ServerWorld param0, IChunk param1, CallbackInfoReturnable<CompoundNBT> cir) {
        if (!(param1 instanceof Chunk)) {
            return;
        }
        LevelChunkBridge chunk = (LevelChunkBridge)param1;
        if (!chunk.bridge$getTrackedShortPlayerPositions().isEmpty() || !chunk.bridge$getTrackedIntPlayerPositions().isEmpty()) {
            CompoundNBT level = (CompoundNBT)((CompoundNBT)cir.getReturnValue()).func_74781_a("Level");
            CompoundNBT trackedNbt = new CompoundNBT();
            ListNBT positions = new ListNBT();
            trackedNbt.func_218657_a("BlockPosTable", (INBT)positions);
            level.func_218657_a("SpongeData", (INBT)trackedNbt);
            ChunkSerializerMixin_Tracker.impl$writeMap(positions, chunk.bridge$getTrackedShortPlayerPositions(), (nbt, pos) -> nbt.func_74777_a("pos", pos.shortValue()));
            ChunkSerializerMixin_Tracker.impl$writeMap(positions, chunk.bridge$getTrackedIntPlayerPositions(), (nbt, pos) -> nbt.func_74768_a("ipos", pos.intValue()));
        }
    }

    private static <T> void impl$writeMap(ListNBT positions, Map<T, PlayerTracker> map, BiConsumer<CompoundNBT, T> consumer) {
        for (Map.Entry<T, PlayerTracker> mapEntry : map.entrySet()) {
            T pos = mapEntry.getKey();
            int ownerUniqueIdIndex = mapEntry.getValue().creatorindex;
            int notifierUniqueIdIndex = mapEntry.getValue().notifierIndex;
            CompoundNBT valueNbt = new CompoundNBT();
            valueNbt.func_74768_a("owner", ownerUniqueIdIndex);
            valueNbt.func_74768_a("notifier", notifierUniqueIdIndex);
            consumer.accept(valueNbt, (CompoundNBT)pos);
            positions.add((Object)valueNbt);
        }
    }

    @Redirect(method={"func_222656_a(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/gen/feature/template/TemplateManager;Lnet/minecraft/village/PointOfInterestManager;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/CompoundNBT;)Lnet/minecraft/world/chunk/ChunkPrimer;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/IChunk;func_217305_b(Z)V"))
    private static void impl$readSpongeLevelData(IChunk chunkAccess, boolean var1, ServerWorld param0, TemplateManager param1, PointOfInterestManager param2, ChunkPos param3, CompoundNBT param4) {
        if (!(chunkAccess instanceof Chunk)) {
            return;
        }
        CompoundNBT level = (CompoundNBT)param4.func_74781_a("Level");
        CompoundNBT spongeData = level.func_74775_l("SpongeData");
        if (spongeData.isEmpty()) {
            return;
        }
        HashMap<Integer, PlayerTracker> trackedIntPlayerPositions = new HashMap<Integer, PlayerTracker>();
        HashMap<Short, PlayerTracker> trackedShortPlayerPositions = new HashMap<Short, PlayerTracker>();
        ListNBT list = spongeData.func_150295_c("BlockPosTable", 10);
        LevelChunkBridge chunk = (LevelChunkBridge)chunkAccess;
        for (INBT tag : list) {
            PlayerTracker tracker = new PlayerTracker();
            CompoundNBT data = (CompoundNBT)tag;
            boolean isShortPos = data.func_74764_b("pos");
            if (data.func_74764_b("owner")) {
                tracker.creatorindex = data.func_74762_e("owner");
            }
            if (data.func_74764_b("notifier")) {
                tracker.notifierIndex = data.func_74762_e("notifier");
            }
            if (tracker.notifierIndex == -1 && tracker.creatorindex == -1) continue;
            if (isShortPos) {
                trackedShortPlayerPositions.put(data.func_74765_d("pos"), tracker);
                continue;
            }
            trackedIntPlayerPositions.put(data.func_74762_e("ipos"), tracker);
        }
        chunk.bridge$setTrackedIntPlayerPositions(trackedIntPlayerPositions);
        chunk.bridge$setTrackedShortPlayerPositions(trackedShortPlayerPositions);
    }
}

