/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import java.util.Set;
import net.minecraft.client.network.login.IClientLoginNetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.IServerLoginNetHandler;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;
import org.spongepowered.common.network.channel.TransactionStore;

public final class ConnectionUtil {
    public static boolean isLoginPhase(EngineConnection connection) {
        return connection instanceof IClientLoginNetHandler || connection instanceof IServerLoginNetHandler;
    }

    public static Set<ResourceKey> getRegisteredChannels(EngineConnection connection) {
        NetworkManager networkManager = ((ConnectionHolderBridge)((Object)connection)).bridge$getConnection();
        return ((ConnectionBridge)networkManager).bridge$getRegisteredChannels();
    }

    public static TransactionStore getTransactionStore(EngineConnection connection) {
        NetworkManager networkManager = ((ConnectionHolderBridge)((Object)connection)).bridge$getConnection();
        return ((ConnectionBridge)networkManager).bridge$getTransactionStore();
    }

    public static void checkHandshakePhase(EngineConnection connection) {
        if (!ConnectionUtil.isLoginPhase(connection)) {
            throw new IllegalStateException("This dispatcher may only be used for connections in the handshake phase.");
        }
    }

    public static void checkPlayPhase(EngineConnection connection) {
        if (ConnectionUtil.isLoginPhase(connection)) {
            throw new IllegalStateException("This dispatcher may only be used for connections in the play phase.");
        }
    }

    private ConnectionUtil() {
    }
}

