/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.EngineConnectionSide;
import org.spongepowered.common.bridge.network.ConnectionHolderBridge;

public final class PacketSender {
    public static void sendTo(EngineConnection connection, IPacket<?> packet) {
        PacketSender.sendTo(connection, packet, (Consumer<Future<? super Void>>)null);
    }

    public static void sendTo(EngineConnection connection, IPacket<?> packet, @Nullable Consumer<Future<? super Void>> listener) {
        NetworkManager networkManager = ((ConnectionHolderBridge)((Object)connection)).bridge$getConnection();
        GenericFutureListener asyncListener = null;
        if (listener != null) {
            EngineConnectionSide<? extends EngineConnection> side = connection.side();
            asyncListener = future -> {
                ThreadTaskExecutor executor = side == EngineConnectionSide.CLIENT ? (ThreadTaskExecutor)Sponge.client() : (ThreadTaskExecutor)Sponge.server();
                executor.execute(() -> listener.accept(future));
            };
        }
        networkManager.func_201058_a(packet, asyncListener);
    }

    public static void sendTo(EngineConnection connection, IPacket<?> packet, CompletableFuture<Void> future) {
        PacketSender.sendTo(connection, packet, (Future<? super Void> sendFuture) -> {
            if (sendFuture.isSuccess()) {
                future.complete(null);
            } else {
                future.completeExceptionally(sendFuture.cause());
            }
        });
    }

    private PacketSender() {
    }
}

