/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelIOException;
import org.spongepowered.api.network.channel.packet.FixedTransactionalPacketBinding;
import org.spongepowered.api.network.channel.packet.HandlerPacketBinding;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketBinding;
import org.spongepowered.api.network.channel.packet.PacketHandler;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.ResponsePacketHandler;
import org.spongepowered.api.network.channel.packet.TransactionalPacketBinding;
import org.spongepowered.api.network.channel.packet.TransactionalPacketRegistry;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.SpongeChannel;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.packet.SpongeFixedTransactionalPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeHandlerPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeTransactionalPacketBinding;

public abstract class AbstractPacketChannel
extends SpongeChannel
implements TransactionalPacketRegistry {
    protected final Map<Class<?>, PacketBinding<?>> byType = new ConcurrentHashMap();
    protected final Map<Integer, PacketBinding<?>> byOpcode = new ConcurrentHashMap();

    public AbstractPacketChannel(int type, ResourceKey key, SpongeChannelManager registry) {
        super(type, key, registry);
    }

    @Override
    public Collection<PacketBinding<?>> bindings() {
        return ImmutableList.copyOf(this.byOpcode.values());
    }

    protected void encodePayload(ChannelBuf payload, Packet packet) {
        ChannelBuf packetContent = this.manager().getBufferAllocator().buffer();
        try {
            this.encodePayloadUnsafe(packetContent, packet);
            ChannelBuffers.write(payload, packetContent);
        }
        catch (Throwable ex) {
            ChannelBuffers.release(payload);
            throw ex;
        }
        finally {
            ChannelBuffers.release(packetContent);
        }
    }

    protected void encodePayloadUnsafe(ChannelBuf payload, Packet packet) {
        try {
            packet.write(payload);
        }
        catch (Throwable ex) {
            throw new ChannelIOException("Failed to encode " + packet.getClass(), ex);
        }
    }

    protected <P extends Packet> P decodePayload(Supplier<P> packetSupplier, ChannelBuf payload) {
        Packet packet = (Packet)packetSupplier.get();
        try {
            packet.read(payload.slice());
        }
        catch (Exception ex) {
            throw new ChannelIOException("Failed to decode " + packet.getClass(), ex);
        }
        return (P)packet;
    }

    protected SpongePacketBinding<Packet> requireBinding(int opcode) {
        SpongePacketBinding binding = (SpongePacketBinding)this.byOpcode.get(opcode);
        if (binding == null) {
            throw new ChannelException("Unknown opcode " + opcode + " for channel " + this.key());
        }
        return binding;
    }

    protected SpongePacketBinding<Packet> requireBinding(Class<? extends Packet> packet) {
        SpongePacketBinding binding = (SpongePacketBinding)this.byType.get(packet);
        if (binding == null) {
            throw new ChannelException("Unknown packet type " + packet + " for channel " + this.key());
        }
        return binding;
    }

    protected void validatePacketClass(Class<?> packetClass) {
        try {
            packetClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("A packet class is required to have a zero arg constructor.");
        }
    }

    @Override
    public <P extends Packet> HandlerPacketBinding<P> register(Class<P> packetClass, int packetOpcode) {
        this.checkPossibleRegistration(packetClass, packetOpcode);
        SpongeHandlerPacketBinding<P> binding = new SpongeHandlerPacketBinding<P>(packetOpcode, packetClass);
        this.byType.put(packetClass, binding);
        this.byOpcode.put(packetOpcode, binding);
        return binding;
    }

    @Override
    public <P extends RequestPacket<R>, R extends Packet> FixedTransactionalPacketBinding<P, R> registerTransactional(Class<P> requestPacketType, Class<R> responsePacketType, int opcode) {
        Objects.requireNonNull(requestPacketType, "requestPacketType");
        Objects.requireNonNull(responsePacketType, "responsePacketType");
        this.checkPossibleRegistration(requestPacketType, opcode);
        SpongeFixedTransactionalPacketBinding<P, R> binding = new SpongeFixedTransactionalPacketBinding<P, R>(opcode, requestPacketType, responsePacketType);
        this.byType.put(requestPacketType, binding);
        this.byOpcode.put(opcode, binding);
        return binding;
    }

    @Override
    public <P extends RequestPacket<R>, R extends Packet> TransactionalPacketBinding<P, R> registerTransactional(Class<P> requestPacketType, int opcode) {
        Objects.requireNonNull(requestPacketType, "requestPacketType");
        this.checkPossibleRegistration(requestPacketType, opcode);
        SpongeTransactionalPacketBinding binding = new SpongeTransactionalPacketBinding(opcode, requestPacketType);
        this.byType.put(requestPacketType, binding);
        this.byOpcode.put(opcode, binding);
        return binding;
    }

    private void checkPossibleRegistration(Class<?> packetClass, int opcode) {
        Objects.requireNonNull(packetClass, "packetClass");
        this.validatePacketClass(packetClass);
        if (this.byType.containsKey(packetClass)) {
            throw new IllegalArgumentException("The packet type \"" + packetClass.getName() + "\" is already registered.");
        }
        if (this.byOpcode.containsKey(opcode)) {
            throw new IllegalArgumentException("The opcode \"" + opcode + "\" is already in use.");
        }
    }

    @Override
    public <P extends RequestPacket<R>, R extends Packet> Optional<TransactionalPacketBinding<P, R>> transactionalBinding(Class<P> requestPacketType) {
        Objects.requireNonNull(requestPacketType, "requestPacketType");
        return Optional.ofNullable((TransactionalPacketBinding)this.byType.get(requestPacketType));
    }

    public <M extends Packet> Optional<PacketBinding<M>> binding(Class<M> packetClass) {
        Objects.requireNonNull(packetClass, "packetClass");
        return Optional.ofNullable(this.byType.get(packetClass));
    }

    @Override
    public Optional<PacketBinding<?>> binding(int opcode) {
        return Optional.ofNullable(this.byOpcode.get(opcode));
    }

    protected <P extends RequestPacket<R>, R extends Packet, C extends EngineConnection> void handleResponse(C connection, TransactionalPacketBinding<P, R> binding, P request, R response) {
        for (ResponsePacketHandler<P, R, C> handler : ((SpongeTransactionalPacketBinding)binding).getResponseHandlers(connection)) {
            try {
                handler.handleResponse(response, request, connection);
            }
            catch (Throwable t2) {
                this.handleException(connection, new ChannelException("Failed to handle packet", t2), null);
            }
        }
    }

    protected <P extends RequestPacket<R>, R extends Packet, C extends EngineConnection> void handleResponseFailure(C connection, TransactionalPacketBinding<P, R> binding, P request, ChannelException response) {
        for (ResponsePacketHandler handler : ((SpongeTransactionalPacketBinding)binding).getResponseHandlers(connection)) {
            try {
                handler.handleFailure(response, request, connection);
            }
            catch (Throwable t2) {
                this.handleException(connection, new ChannelException("Failed to handle packet failure", t2), null);
            }
        }
    }

    protected <P extends Packet, C extends EngineConnection> void handle(C connection, HandlerPacketBinding<P> binding, P packet) {
        for (PacketHandler<P, C> handler : ((SpongeHandlerPacketBinding)binding).getHandlers(connection)) {
            try {
                handler.handle(packet, connection);
            }
            catch (Throwable t2) {
                this.handleException(connection, new ChannelException("Failed to handle packet", t2), null);
            }
        }
    }

    static final class TransactionData<P extends RequestPacket<R>, R extends Packet> {
        final P request;
        final SpongeTransactionalPacketBinding<P, R> binding;
        final CompletableFuture<?> future;
        final @Nullable Consumer<R> success;

        TransactionData(P request, SpongeTransactionalPacketBinding<P, R> binding, @Nullable Consumer<R> success, CompletableFuture<?> future) {
            this.request = request;
            this.binding = binding;
            this.success = success;
            this.future = future;
        }
    }
}

