/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.IPacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.ChannelException;
import org.spongepowered.api.network.channel.ChannelIOException;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketDispatcher;
import org.spongepowered.api.network.channel.packet.RequestPacket;
import org.spongepowered.api.network.channel.packet.RequestPacketHandler;
import org.spongepowered.api.network.channel.packet.basic.BasicHandshakePacketDispatcher;
import org.spongepowered.api.network.channel.packet.basic.BasicPacketChannel;
import org.spongepowered.common.network.channel.ChannelBuffers;
import org.spongepowered.common.network.channel.ChannelExceptionUtil;
import org.spongepowered.common.network.channel.ConnectionUtil;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.PacketUtil;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.channel.TransactionResult;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.network.channel.packet.AbstractPacketChannel;
import org.spongepowered.common.network.channel.packet.SpongeFixedTransactionalPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeHandlerPacketBinding;
import org.spongepowered.common.network.channel.packet.SpongePacketBinding;
import org.spongepowered.common.network.channel.packet.SpongeRequestPacketResponse;
import org.spongepowered.common.network.channel.packet.SpongeTransactionalPacketBinding;
import org.spongepowered.common.util.Constants;

public final class SpongeBasicPacketChannel
extends AbstractPacketChannel
implements BasicPacketChannel {
    private final BasicHandshakePacketDispatcher handshake = new BasicHandshakePacketDispatcher(){

        @Override
        public <R extends Packet> CompletableFuture<R> sendTo(EngineConnection connection, RequestPacket<R> packet) {
            ConnectionUtil.checkHandshakePhase(connection);
            if (connection instanceof ClientSideConnection) {
                throw new UnsupportedOperationException("Request packets from the client to server are currently not supported for basic packet channels.");
            }
            CompletableFuture future = new CompletableFuture();
            this.sendRequestTo(connection, packet, future::complete, null, future);
            return future;
        }

        private <P extends RequestPacket<R>, R extends Packet> void sendRequestTo(EngineConnection connection, P request, @Nullable Consumer<R> success, @Nullable Runnable sendSuccess, CompletableFuture<?> future) {
            ChannelBuf payload;
            SpongeTransactionalPacketBinding binding = (SpongeTransactionalPacketBinding)SpongeBasicPacketChannel.this.requireBinding(request.getClass());
            try {
                payload = SpongeBasicPacketChannel.this.encodeLoginPayload(binding.opcode(), request);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, ex, future);
                return;
            }
            TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
            int transactionId = transactionStore.nextId();
            IPacket<?> mcPacket = PacketUtil.createLoginPayloadRequest(Constants.Channels.FML_LOGIN_WRAPPER_CHANNEL, payload, transactionId);
            PacketSender.sendTo(connection, mcPacket, sendFuture -> {
                if (!sendFuture.isSuccess()) {
                    SpongeBasicPacketChannel.this.handleException(connection, ChannelExceptionUtil.of(sendFuture.cause()), future);
                } else {
                    AbstractPacketChannel.TransactionData transactionData = new AbstractPacketChannel.TransactionData(request, binding, success, future);
                    transactionStore.put(transactionId, SpongeBasicPacketChannel.this, transactionData);
                    if (sendSuccess != null) {
                        sendSuccess.run();
                    }
                }
            });
        }

        private CompletableFuture<Void> sendNormalTo(EngineConnection connection, Packet packet) {
            ChannelBuf payload;
            SpongePacketBinding<Packet> binding = SpongeBasicPacketChannel.this.requireBinding(packet.getClass());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            try {
                payload = SpongeBasicPacketChannel.this.encodePayload(binding.opcode(), packet);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, ChannelExceptionUtil.of(ex), future);
                return future;
            }
            TransactionStore transactionStore = ConnectionUtil.getTransactionStore(connection);
            int transactionId = transactionStore.nextId();
            IPacket<?> mcPacket = PacketUtil.createLoginPayloadRequest(SpongeBasicPacketChannel.this.key(), payload, transactionId);
            PacketSender.sendTo(connection, mcPacket, future);
            return future;
        }

        @Override
        public CompletableFuture<Void> sendTo(EngineConnection connection, Packet packet) {
            ConnectionUtil.checkHandshakePhase(connection);
            if (connection instanceof ClientSideConnection) {
                throw new UnsupportedOperationException("Packets from the client to server are currently not supported for basic packet channels.");
            }
            if (packet instanceof RequestPacket) {
                CompletableFuture<Void> future = new CompletableFuture<Void>();
                this.sendRequestTo(connection, (RequestPacket)packet, result -> {}, () -> future.complete(null), future);
                return future;
            }
            return this.sendNormalTo(connection, packet);
        }

        @Override
        public <R extends Packet> CompletableFuture<R> sendToServer(RequestPacket<R> packet) {
            throw new UnsupportedOperationException("Request packets from the client to server are currently not supported for basic packet channels.");
        }

        @Override
        public CompletableFuture<Void> sendToServer(Packet packet) {
            throw new UnsupportedOperationException("Packets from the client to server are currently not supported for basic packet channels.");
        }
    };
    private final PacketDispatcher play = new PacketDispatcher(){

        @Override
        public boolean isSupportedBy(EngineConnection connection) {
            return ConnectionUtil.getRegisteredChannels(connection).contains(SpongeBasicPacketChannel.this.key());
        }

        @Override
        public CompletableFuture<Void> sendTo(EngineConnection connection, Packet packet) {
            ChannelBuf payload;
            ConnectionUtil.checkPlayPhase(connection);
            SpongePacketBinding<Packet> binding = SpongeBasicPacketChannel.this.requireBinding(packet.getClass());
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            if (!SpongeBasicPacketChannel.this.checkSupported(connection, future)) {
                return future;
            }
            try {
                payload = SpongeBasicPacketChannel.this.encodePayload(binding.opcode(), packet);
            }
            catch (Throwable ex) {
                SpongeBasicPacketChannel.this.handleException(connection, ex, future);
                return future;
            }
            IPacket<?> mcPacket = PacketUtil.createPlayPayload(SpongeBasicPacketChannel.this.key(), payload, connection.side());
            PacketSender.sendTo(connection, mcPacket, future);
            return future;
        }
    };

    public SpongeBasicPacketChannel(int type, ResourceKey key, SpongeChannelManager registry) {
        super(type, key, registry);
    }

    @Override
    public BasicHandshakePacketDispatcher handshake() {
        return this.handshake;
    }

    @Override
    public PacketDispatcher play() {
        return this.play;
    }

    private ChannelBuf encodePayload(int opcode, Packet packet) {
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        payload.writeByte((byte)opcode);
        this.encodePayload(payload, packet);
        return payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuf encodeLoginPayload(int opcode, Packet packet) {
        ChannelBuf loginPayload = this.manager().getBufferAllocator().buffer();
        ChannelBuf payload = this.manager().getBufferAllocator().buffer();
        try {
            this.encodePayloadUnsafe(payload, packet);
            loginPayload.writeString(this.key().formatted());
            loginPayload.writeVarInt(payload.available() + 1);
            loginPayload.writeByte((byte)opcode);
            ChannelBuffers.write(loginPayload, payload);
        }
        finally {
            ChannelBuffers.release(payload);
        }
        return loginPayload;
    }

    private int readOpcode(ChannelBuf payload) {
        return payload.readByte() & 0xFF;
    }

    @Override
    protected void handlePlayPayload(EngineConnection connection, ChannelBuf payload) {
        int opcode = this.readOpcode(payload);
        SpongePacketBinding<Packet> binding = this.requireBinding(opcode);
        Packet packet = this.decodePayload(() -> (Packet)binding.getPacketConstructor().get(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            this.handle(connection, (SpongeHandlerPacketBinding)binding, packet);
        }
    }

    @Override
    protected void handleLoginRequestPayload(final EngineConnection connection, final int transactionId, ChannelBuf payload) {
        int opcode = this.readOpcode(payload);
        SpongePacketBinding<Packet> binding = this.requireBinding(opcode);
        Packet packet = this.decodePayload(() -> (Packet)binding.getPacketConstructor().get(), payload);
        if (binding instanceof SpongeHandlerPacketBinding) {
            SpongeHandlerPacketBinding handlerBinding = (SpongeHandlerPacketBinding)binding;
            this.handle(connection, handlerBinding, packet);
            PacketSender.sendTo(connection, PacketUtil.createLoginPayloadResponse(null, transactionId));
        } else {
            final SpongeTransactionalPacketBinding transactionalBinding = (SpongeTransactionalPacketBinding)binding;
            RequestPacketHandler<Packet, Packet, EngineConnection> handler = transactionalBinding.getRequestHandler(connection);
            boolean success = false;
            if (handler != null) {
                SpongeRequestPacketResponse<Packet> response = new SpongeRequestPacketResponse<Packet>(){

                    @Override
                    protected void fail0(ChannelException exception) {
                        IPacket<?> mcPacket = PacketUtil.createLoginPayloadResponse(null, transactionId);
                        PacketSender.sendTo(connection, mcPacket);
                    }

                    @Override
                    protected void success0(Packet response) {
                        try {
                            ChannelBuf responsePayload = SpongeBasicPacketChannel.this.encodeLoginPayload(transactionalBinding.opcode(), response);
                            IPacket<?> mcPacket = PacketUtil.createLoginPayloadResponse(responsePayload, transactionId);
                            PacketSender.sendTo(connection, mcPacket);
                        }
                        catch (Throwable ex) {
                            SpongeBasicPacketChannel.this.handleException(connection, new ChannelIOException("Failed to encode response packet", ex), null);
                        }
                    }
                };
                try {
                    handler.handleRequest(packet, connection, response);
                    success = true;
                }
                catch (Throwable ex) {
                    this.handleException(connection, new ChannelIOException("Failed to handle request packet", ex), null);
                }
            }
            if (!success) {
                IPacket<?> mcPacket = PacketUtil.createLoginPayloadResponse(null, transactionId);
                PacketSender.sendTo(connection, mcPacket);
            }
        }
    }

    @Override
    protected void handleTransactionResponse(EngineConnection connection, Object stored, TransactionResult result) {
        AbstractPacketChannel.TransactionData transactionData = (AbstractPacketChannel.TransactionData)stored;
        this.handleTransactionResponse(connection, transactionData, result);
    }

    private <P extends RequestPacket<R>, R extends Packet> void handleTransactionResponse(EngineConnection connection, AbstractPacketChannel.TransactionData<P, R> transactionData, TransactionResult result) {
        SpongeTransactionalPacketBinding binding = transactionData.binding;
        Object request = transactionData.request;
        if (result.isSuccess()) {
            ChannelBuf responsePayload = result.getPayload();
            responsePayload.readString();
            int actualLength = responsePayload.readVarInt();
            responsePayload = responsePayload.readSlice(actualLength);
            try {
                Supplier<Object> responseConstructor;
                int opcode = this.readOpcode(responsePayload);
                if (binding instanceof SpongeFixedTransactionalPacketBinding) {
                    responseConstructor = ((SpongeFixedTransactionalPacketBinding)binding).getResponsePacketConstructor();
                } else {
                    SpongeHandlerPacketBinding responseBinding = (SpongeHandlerPacketBinding)this.byOpcode.get(opcode);
                    if (responseBinding == null) {
                        throw new ChannelIOException("Unknown packet opcode: " + opcode);
                    }
                    responseConstructor = responseBinding.getPacketConstructor();
                }
                Object responsePacket = this.decodePayload(responseConstructor, responsePayload);
                if (transactionData.success != null) {
                    transactionData.success.accept(responsePacket);
                }
                this.handleResponse(connection, binding, request, responsePacket);
            }
            catch (Throwable ex) {
                this.handleException(connection, ex, transactionData.future);
            }
        } else {
            this.handleException(connection, result.getCause(), transactionData.future);
            this.handleResponseFailure(connection, binding, request, result.getCause());
        }
    }
}

