/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.packet;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnectionTypes;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.network.channel.SpongeChannelManager;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RequestBlockTrackerDataPacket;
import org.spongepowered.common.network.packet.RequestEntityTrackerDataPacket;
import org.spongepowered.common.network.packet.TrackerDataResponsePacket;

public final class SpongePacketHandler {
    private static PacketChannel channel;

    public static void init(SpongeChannelManager registry) {
        channel = registry.createChannel(ResourceKey.sponge("default"), PacketChannel.class);
        channel.registerTransactional(RequestBlockTrackerDataPacket.class, TrackerDataResponsePacket.class, 0).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.block-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            BlockPos pos = new BlockPos(requestPacket.x, requestPacket.y, requestPacket.z);
            if (!sender.field_70170_p.func_175667_e(pos)) {
                return;
            }
            LevelChunkBridge levelChunkBridge = (LevelChunkBridge)sender.field_70170_p.func_175726_f(pos);
            Optional<UUID> owner = levelChunkBridge.bridge$getBlockCreatorUUID(pos);
            Optional<UUID> notifier = levelChunkBridge.bridge$getBlockNotifierUUID(pos);
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.registerTransactional(RequestEntityTrackerDataPacket.class, TrackerDataResponsePacket.class, 1).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.player();
            if (!player.hasPermission("sponge.debug.entity-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            Entity entity = sender.field_70170_p.func_73045_a(requestPacket.entityId);
            if (!(entity instanceof CreatorTrackedBridge)) {
                return;
            }
            CreatorTrackedBridge creatorTrackedBridge = (CreatorTrackedBridge)entity;
            Optional<UUID> owner = creatorTrackedBridge.tracker$getCreatorUUID();
            Optional<UUID> notifier = creatorTrackedBridge.tracker$getNotifierUUID();
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.register(ChangeViewerEnvironmentPacket.class, 3).addHandler(ClientSideConnection.class, (packet, connection) -> {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            DimensionType dimensionType = (DimensionType)SpongeCommon.server().func_244267_aX().func_230520_a_().func_82594_a(packet.dimensionLogic);
            ((LevelBridge)world).bridge$adjustDimensionLogic(dimensionType);
        });
    }

    private static TrackerDataResponsePacket createTrackerDataResponse(Optional<UUID> owner, Optional<UUID> notifier) {
        String ownerName = owner.map(x -> SpongeCommon.server().func_152358_ax().func_152652_a(x)).filter(Objects::nonNull).map(GameProfile::getName).orElse("");
        String notifierName = notifier.map(x -> SpongeCommon.server().func_152358_ax().func_152652_a(x)).filter(Objects::nonNull).map(GameProfile::getName).orElse("");
        return new TrackerDataResponsePacket(ownerName, notifierName);
    }

    public static PacketChannel getChannel() {
        return Objects.requireNonNull(channel);
    }
}

