/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.status;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.net.InetSocketAddress;
import java.util.Optional;
import net.minecraft.network.NetworkManager;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.network.status.StatusClient;
import org.spongepowered.common.bridge.network.ConnectionBridge;

public class SpongeStatusClient
implements StatusClient {
    private final ConnectionBridge connection;

    public SpongeStatusClient(NetworkManager networkManager) {
        this.connection = (ConnectionBridge)networkManager;
    }

    @Override
    public InetSocketAddress address() {
        return this.connection.bridge$getAddress();
    }

    @Override
    public MinecraftVersion version() {
        return this.connection.bridge$getVersion();
    }

    @Override
    public Optional<InetSocketAddress> virtualHost() {
        return Optional.ofNullable(this.connection.bridge$getVirtualHost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpongeStatusClient)) {
            return false;
        }
        SpongeStatusClient that = (SpongeStatusClient)o;
        return Objects.equal((Object)this.connection, (Object)that.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.connection).toString();
    }
}

