/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryRoots;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.common.accessor.core.RegistryAccessAccessor;
import org.spongepowered.common.accessor.resources.ResourceKeyAccessor;
import org.spongepowered.common.bridge.core.WritableRegistryBridge;
import org.spongepowered.common.registry.CallbackRegistry;
import org.spongepowered.common.registry.InitialRegistryData;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.SpongeMappedRegistry;
import org.spongepowered.common.registry.TagRegistry;

public final class RegistryHolderLogic
implements RegistryHolder {
    private final Map<ResourceKey, Registry<Registry<?>>> roots = new Object2ObjectOpenHashMap();

    public RegistryHolderLogic() {
        this.roots.put((ResourceKey)new ResourceLocation("minecraft", "root"), (Registry<Registry<?>>)new SimpleRegistry(RegistryKey.func_240904_a_((ResourceLocation)((ResourceLocation)RegistryRoots.MINECRAFT)), Lifecycle.experimental()));
        ResourceLocation sponge = new ResourceLocation("sponge", "root");
        this.roots.put((ResourceKey)sponge, (Registry<Registry<?>>)new SimpleRegistry(ResourceKeyAccessor.invoker$create(sponge, sponge), Lifecycle.stable()));
    }

    public RegistryHolderLogic(DynamicRegistries dynamicAccess) {
        this();
        MutableRegistry root = (MutableRegistry)this.roots.get(new ResourceLocation("minecraft", "root"));
        for (RegistryKey<? extends Registry<?>> registryKey : RegistryAccessAccessor.accessor$REGISTRIES().keySet()) {
            MutableRegistry registry = dynamicAccess.func_243612_b(registryKey);
            root.func_218381_a(registryKey, (Object)registry, Lifecycle.stable());
        }
    }

    public void setRootMinecraftRegistry(Registry<Registry<?>> rootRegistry) {
        this.roots.put(RegistryRoots.MINECRAFT, rootRegistry);
    }

    @Override
    public <T> org.spongepowered.api.registry.Registry<T> registry(RegistryType<T> type) {
        Registry<Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        Registry registry = (Registry)root.func_82594_a((ResourceLocation)type.location());
        if (registry == null) {
            throw new ValueNotFoundException(String.format("No '%s' registry has been defined in root '%s'", type.location(), type.root()));
        }
        return (org.spongepowered.api.registry.Registry)registry;
    }

    @Override
    public <T> Optional<org.spongepowered.api.registry.Registry<T>> findRegistry(RegistryType<T> type) {
        Registry<Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            return Optional.empty();
        }
        return root.func_241873_b((ResourceLocation)type.location());
    }

    @Override
    public Stream<org.spongepowered.api.registry.Registry<?>> streamRegistries(ResourceKey root) {
        Registry<Registry<?>> rootRegistry = this.roots.get(Objects.requireNonNull(root, "root"));
        if (rootRegistry == null) {
            return Stream.empty();
        }
        return rootRegistry.func_201756_e();
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Map<ResourceKey, T> defaultValues) {
        return this.createRegistry(type, defaultValues != null ? () -> defaultValues : null, false);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues) {
        return this.createRegistry(type, defaultValues, false);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, InitialRegistryData.noIds(defaultValues), this.registrySupplier(isDynamic, null));
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader) {
        return this.createRegistry(type, loader, false);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, RegistryLoader<T> loader, boolean isDynamic) {
        return this.createRegistry(type, loader, this.registrySupplier(isDynamic, null));
    }

    public <T> Function<RegistryKey<Registry<T>>, Registry<T>> registrySupplier(boolean isDynamic, @Nullable BiConsumer<RegistryKey<T>, T> callback) {
        if (callback == null) {
            return key -> {
                SimpleRegistry reg = new SimpleRegistry(key, Lifecycle.stable());
                ((WritableRegistryBridge)reg).bridge$setDynamic(isDynamic);
                return reg;
            };
        }
        return key -> {
            CallbackRegistry reg = new CallbackRegistry(key, Lifecycle.stable(), callback);
            ((WritableRegistryBridge)((Object)reg)).bridge$setDynamic(isDynamic);
            return reg;
        };
    }

    public <T> Function<RegistryKey<Registry<T>>, Registry<T>> identityRegistrySupplier(boolean isDynamic) {
        return key -> {
            SpongeMappedRegistry reg = new SpongeMappedRegistry(key, Lifecycle.stable());
            ((WritableRegistryBridge)((Object)reg)).bridge$setDynamic(isDynamic);
            return reg;
        };
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable InitialRegistryData<T> defaultValues, Function<RegistryKey<Registry<T>>, Registry<T>> registrySupplier) {
        Registry<Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        Registry<T> registry = (Registry<T>)root.func_82594_a((ResourceLocation)type.location());
        if (registry != null) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        RegistryKey key = Registry.field_239706_f_.equals((Object)type.root()) ? RegistryKey.func_240904_a_((ResourceLocation)((ResourceLocation)type.location())) : ResourceKeyAccessor.invoker$create((ResourceLocation)RegistryRoots.SPONGE, (ResourceLocation)type.location());
        registry = registrySupplier.apply(key);
        if (defaultValues != null) {
            MutableRegistry mr = (MutableRegistry)registry;
            defaultValues.forEach((vk, vi, vv) -> mr.func_241874_a(vi, RegistryKey.func_240903_a_((RegistryKey)key, (ResourceLocation)((ResourceLocation)vk)), vv, Lifecycle.stable()));
        }
        ((MutableRegistry)root).func_218381_a(key, registry, Lifecycle.stable());
        if (registry instanceof CallbackRegistry) {
            ((CallbackRegistry)registry).setCallbackEnabled(true);
        }
        return (org.spongepowered.api.registry.Registry)registry;
    }

    public <T> org.spongepowered.api.registry.Registry<T> wrapTagHelperAsRegistry(RegistryType<Tag<T>> type, net.minecraft.tags.TagRegistry<T> staticTagHelper) {
        Registry<Registry<?>> root = this.roots.get(Objects.requireNonNull(type, "type").root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        TagRegistry<T> registry = (TagRegistry<T>)((Object)root.func_82594_a((ResourceLocation)type.location()));
        if (registry != null) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        RegistryKey key = Registry.field_239706_f_.equals((Object)type.root()) ? RegistryKey.func_240904_a_((ResourceLocation)((ResourceLocation)type.location())) : ResourceKeyAccessor.invoker$create((ResourceLocation)RegistryRoots.SPONGE, (ResourceLocation)type.location());
        registry = new TagRegistry<T>(key, staticTagHelper, Lifecycle.stable());
        ((MutableRegistry)root).func_218381_a(key, registry, Lifecycle.stable());
        return (org.spongepowered.api.registry.Registry)((Object)registry);
    }
}

