/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SpongeMappedRegistry<T>
extends MutableRegistry<T> {
    protected static final Logger LOGGER = LogManager.getLogger();
    private final ObjectList<T> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)Util.func_200696_a((Object)new Object2IntOpenCustomHashMap(Util.func_212443_g()), $$0x -> $$0x.defaultReturnValue(-1));
    private final Map<ResourceLocation, T> storage = new HashMap<ResourceLocation, T>();
    private final IdentityHashMap<T, ResourceLocation> inverseStorage = Maps.newIdentityHashMap();
    private final Map<RegistryKey<T>, T> keyStorage = new HashMap<RegistryKey<T>, T>();
    private final IdentityHashMap<T, RegistryKey<T>> inverseKeyStorage = Maps.newIdentityHashMap();
    private final Map<T, Lifecycle> lifecycles = Maps.newIdentityHashMap();
    private Lifecycle elementsLifecycle;
    private int nextId;

    public SpongeMappedRegistry(RegistryKey<? extends Registry<T>> $$0, Lifecycle $$1) {
        super($$0, $$1);
        this.elementsLifecycle = $$1;
    }

    public <V extends T> V func_218382_a(int $$0, RegistryKey<T> $$1, V $$2, Lifecycle $$3) {
        Validate.notNull($$1);
        Validate.notNull($$2);
        this.byId.size(Math.max(this.byId.size(), $$0 + 1));
        this.byId.set($$0, $$2);
        this.toId.put($$2, $$0);
        this.storage.put($$1.func_240901_a_(), $$2);
        this.inverseStorage.put($$2, $$1.func_240901_a_());
        this.keyStorage.put($$1, $$2);
        this.inverseKeyStorage.put($$2, $$1);
        this.lifecycles.put($$2, $$3);
        this.elementsLifecycle = this.elementsLifecycle.add($$3);
        if (this.nextId <= $$0) {
            this.nextId = $$0 + 1;
        }
        return $$2;
    }

    public <V extends T> V func_218381_a(RegistryKey<T> $$0, V $$1, Lifecycle $$2) {
        return this.func_218382_a(this.nextId, $$0, $$1, $$2);
    }

    public <V extends T> V func_241874_a(OptionalInt $$0, RegistryKey<T> $$1, V $$2, Lifecycle $$3) {
        int $$5;
        Validate.notNull($$1);
        Validate.notNull($$2);
        T $$4 = this.keyStorage.get($$1);
        if ($$4 == null) {
            $$5 = $$0.isPresent() ? $$0.getAsInt() : this.nextId;
        } else {
            $$5 = this.toId.getInt($$4);
            if ($$0.isPresent() && $$0.getAsInt() != $$5) {
                throw new IllegalStateException("ID mismatch");
            }
            this.toId.removeInt($$4);
            this.lifecycles.remove($$4);
        }
        return this.func_218382_a($$5, $$1, $$2, $$3);
    }

    @Nullable
    public ResourceLocation func_177774_c(T $$0) {
        return this.inverseStorage.get($$0);
    }

    public Optional<RegistryKey<T>> func_230519_c_(T $$0) {
        return Optional.ofNullable(this.inverseKeyStorage.get($$0));
    }

    public int func_148757_b(@Nullable T $$0) {
        return this.toId.getInt($$0);
    }

    @Nullable
    public T func_230516_a_(@Nullable RegistryKey<T> $$0) {
        return this.keyStorage.get($$0);
    }

    @Nullable
    public T func_148745_a(int $$0) {
        return (T)($$0 >= 0 && $$0 < this.byId.size() ? this.byId.get($$0) : null);
    }

    public Lifecycle func_241876_d(T $$0) {
        return this.lifecycles.get($$0);
    }

    public Lifecycle func_241875_b() {
        return this.elementsLifecycle;
    }

    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.byId.iterator(), Objects::nonNull);
    }

    @Nullable
    public T func_82594_a(@Nullable ResourceLocation $$0) {
        return this.storage.get($$0);
    }

    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.storage.keySet());
    }

    public Set<Map.Entry<RegistryKey<T>, T>> func_239659_c_() {
        return Collections.unmodifiableMap(this.keyStorage).entrySet();
    }

    public boolean func_212607_c(ResourceLocation $$0) {
        return this.storage.containsKey($$0);
    }
}

