/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.common.bridge.core.RegistryBridge;
import org.spongepowered.common.bridge.tags.TagWrapperBridge;
import org.spongepowered.common.registry.SpongeRegistryEntry;

public final class TagRegistry<T>
extends Registry<Tag<T>> {
    private final net.minecraft.tags.TagRegistry<T> staticTagHelper;
    private final Map<ResourceKey, Tag<T>> wrapperCache = HashBiMap.create();
    private final Lifecycle lifecycle;
    private final RegistryType<Tag<T>> type;

    public TagRegistry(RegistryKey<? extends Registry<Tag<T>>> registryKey, net.minecraft.tags.TagRegistry<T> staticTagHelper, Lifecycle lifecycle) {
        super(registryKey, lifecycle);
        this.staticTagHelper = staticTagHelper;
        this.lifecycle = lifecycle;
        RegistryBridge bridge = (RegistryBridge)((Object)this);
        this.type = bridge.bridge$type();
        bridge.bridge$overrideStream(this::tagStream);
    }

    public @Nullable ResourceLocation getKey(Tag<T> var1) {
        return this.staticTagHelper.func_232939_b_().func_232973_a_((ITag)var1);
    }

    public Optional<RegistryKey<Tag<T>>> getResourceKey(Tag<T> var1) {
        ResourceLocation valueLocation = this.getKey(var1);
        if (valueLocation == null) {
            return Optional.empty();
        }
        return Optional.of(RegistryKey.func_240903_a_((RegistryKey)this.func_243578_f(), (ResourceLocation)valueLocation));
    }

    public int getId(@Nullable Tag<T> var1) {
        throw new UnsupportedOperationException("IDs are not supported!");
    }

    public @Nullable Tag<T> byId(int var1) {
        throw new UnsupportedOperationException("IDs are not supported!");
    }

    public @Nullable Tag<T> get(RegistryKey<Tag<T>> resourceKey) {
        if (!resourceKey.func_244356_a(this.func_243578_f())) {
            throw new IllegalStateException("Minecraft ResourceKey " + resourceKey + " is not for registry " + this.func_243578_f());
        }
        return this.get(resourceKey.func_240901_a_());
    }

    public @Nullable Tag<T> get(@Nullable ResourceLocation key) {
        Tag<T> cachedTag = this.wrapperCache.get(key);
        if (cachedTag != null) {
            return cachedTag;
        }
        ITag setTag = this.staticTagHelper.func_232939_b_().func_199910_a(key);
        if (setTag == null) {
            return null;
        }
        return this.getWrapped((ResourceKey)key, setTag);
    }

    protected Lifecycle lifecycle(Tag<T> var1) {
        return this.lifecycle;
    }

    public Lifecycle func_241875_b() {
        return this.lifecycle;
    }

    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.staticTagHelper.func_232939_b_().func_241833_a().keySet());
    }

    public Set<Map.Entry<RegistryKey<Tag<T>>, Tag<T>>> func_239659_c_() {
        return Collections.unmodifiableSet(this.staticTagHelper.func_232939_b_().func_241833_a().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<RegistryKey, Tag<T>>(RegistryKey.func_240903_a_((RegistryKey)this.func_243578_f(), (ResourceLocation)((ResourceLocation)entry.getKey())), this.getWrapped((ResourceKey)entry.getKey(), (ITag)entry.getValue()))).collect(Collectors.toSet()));
    }

    public Stream<Tag<T>> func_201756_e() {
        return this.tagStream().map(RegistryEntry::value);
    }

    public boolean func_212607_c(ResourceLocation var1) {
        return this.staticTagHelper.func_232939_b_().func_241833_a().containsKey(var1);
    }

    public @NonNull Iterator<Tag<T>> iterator() {
        return this.tagStream().map(RegistryEntry::value).iterator();
    }

    private Tag<T> getWrapped(ResourceKey key, ITag<T> setTag) {
        Tag<T> cached = this.wrapperCache.get(key);
        if (cached != null) {
            return cached;
        }
        Tag result = this.staticTagHelper.func_241288_c_().stream().filter(named -> named.func_230234_a_().equals((Object)key)).map(tag -> (Tag)tag).findAny().orElseGet(() -> {
            Tag tag = (Tag)this.staticTagHelper.func_232937_a_(key.asString());
            ((TagWrapperBridge)((Object)tag)).bridge$rebindTo(setTag);
            return tag;
        });
        this.wrapperCache.put(key, result);
        return result;
    }

    private Stream<RegistryEntry<Tag<T>>> tagStream() {
        return this.staticTagHelper.func_232939_b_().func_241833_a().entrySet().stream().map(x -> {
            ResourceKey resourceKey = (ResourceKey)x.getKey();
            return new SpongeRegistryEntry<Tag<T>>(this.type, resourceKey, this.getWrapped(resourceKey, (ITag)x.getValue()));
        });
    }
}

