/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.util.Functional;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.scheduler.SpongeScheduledTask;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.util.PrettyPrinter;

public final class AsyncScheduler
extends SpongeScheduler {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final AtomicBoolean stateChanged = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Sponge-AsyncScheduler-%d").build());
    private volatile boolean running = true;
    private long minimumTimeout = Long.MAX_VALUE;
    private long lastProcessingTimestamp;

    public AsyncScheduler() {
        super("A");
        Thread thread = new Thread(this::mainLoop);
        thread.setName("Sponge Async Scheduler Thread");
        thread.setDaemon(true);
        thread.start();
    }

    private void mainLoop() {
        this.lastProcessingTimestamp = System.nanoTime();
        while (this.running) {
            this.recalibrateMinimumTimeout();
            this.runTick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalibrateMinimumTimeout() {
        this.lock.lock();
        try {
            Set<ScheduledTask> tasks = this.tasks();
            this.minimumTimeout = Long.MAX_VALUE;
            long now = System.nanoTime();
            for (ScheduledTask tmpTask : tasks) {
                SpongeScheduledTask task = (SpongeScheduledTask)tmpTask;
                if (task.state() == SpongeScheduledTask.ScheduledTaskState.EXECUTING) continue;
                if (task.task.delay == 0L && task.task.interval == 0L) {
                    this.minimumTimeout = 0L;
                }
                long timeSinceLast = now - task.timestamp();
                if (task.task.delay > 0L && task.state() == SpongeScheduledTask.ScheduledTaskState.WAITING) {
                    this.minimumTimeout = Math.min(task.task.delay - timeSinceLast, this.minimumTimeout);
                }
                if (task.task.interval > 0L && task.state().isActive) {
                    this.minimumTimeout = Math.min(task.task.interval - timeSinceLast, this.minimumTimeout);
                }
                if (this.minimumTimeout > 0L) continue;
                break;
            }
            if (!tasks.isEmpty()) {
                long latency = System.nanoTime() - this.lastProcessingTimestamp;
                this.minimumTimeout -= latency <= 0L ? 0L : latency;
                this.minimumTimeout = this.minimumTimeout < 0L ? 0L : this.minimumTimeout;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void addTask(SpongeScheduledTask task) {
        this.lock.lock();
        try {
            super.addTask(task);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void preTick() {
        this.lock.lock();
        try {
            if (!this.stateChanged.get()) {
                this.condition.await(this.minimumTimeout, TimeUnit.NANOSECONDS);
            }
            this.stateChanged.set(false);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalMonitorStateException e) {
            SpongeCommon.logger().error("The scheduler internal state machine suffered a catastrophic error", (Throwable)e);
        }
    }

    @Override
    protected void postTick() {
        this.lastProcessingTimestamp = System.nanoTime();
    }

    @Override
    protected void finallyPostTick() {
        this.lock.unlock();
    }

    @Override
    protected void onTaskCompletion(SpongeScheduledTask task) {
        if (task.state() == SpongeScheduledTask.ScheduledTaskState.RUNNING) {
            this.lock.lock();
            try {
                this.stateChanged.set(true);
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    protected void executeRunnable(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public <T> CompletableFuture<T> submit(Callable<T> callable) {
        return Functional.asyncFailableFuture(callable, this.executor);
    }

    public void close() {
        this.running = false;
        Set<ScheduledTask> tasks = this.tasks();
        tasks.forEach(ScheduledTask::cancel);
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                new PrettyPrinter().add("Sponge async scheduler failed to shut down in 5 seconds! Tasks that may have been active:").addWithIndices(tasks).add().add("We will now attempt immediate shutdown.").log(SpongeCommon.logger(), Level.WARN);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            SpongeCommon.logger().error("The async scheduler was interrupted while awaiting shutdown!");
        }
    }
}

