/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.scheduler.SpongeScheduledTask;
import org.spongepowered.common.scheduler.SpongeTask;
import org.spongepowered.common.scheduler.SpongeTaskExecutorService;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongeScheduler
implements Scheduler {
    private static final AtomicInteger TASK_CREATED_COUNTER = new AtomicInteger();
    private static final int TICK_DURATION_MS = 50;
    static final long TICK_DURATION_NS = TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS);
    private final String tag;
    protected final Map<UUID, SpongeScheduledTask> tasks = new ConcurrentHashMap<UUID, SpongeScheduledTask>();
    private long sequenceNumber = 0L;

    SpongeScheduler(String tag) {
        this.tag = tag;
    }

    protected long timestamp(boolean tickBased) {
        return System.nanoTime();
    }

    protected void addTask(SpongeScheduledTask task) {
        task.setTimestamp(this.timestamp(task.task.tickBasedDelay));
        this.tasks.put(task.uniqueId(), task);
    }

    private void removeTask(SpongeScheduledTask task) {
        this.tasks.remove(task.uniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ScheduledTask> findTask(UUID id) {
        Objects.requireNonNull(id, "id");
        Map<UUID, SpongeScheduledTask> map = this.tasks;
        synchronized (map) {
            return Optional.ofNullable((ScheduledTask)this.tasks.get(id));
        }
    }

    @Override
    public Set<ScheduledTask> findTasks(String pattern) {
        Pattern searchPattern = Pattern.compile(Objects.requireNonNull(pattern, "pattern"));
        Set<ScheduledTask> matchingTasks = this.tasks();
        Iterator<ScheduledTask> it = matchingTasks.iterator();
        while (it.hasNext()) {
            Matcher matcher = searchPattern.matcher(it.next().name());
            if (matcher.matches()) continue;
            it.remove();
        }
        return matchingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ScheduledTask> tasks() {
        Map<UUID, SpongeScheduledTask> map = this.tasks;
        synchronized (map) {
            return Sets.newHashSet(this.tasks.values());
        }
    }

    @Override
    public Set<ScheduledTask> tasks(PluginContainer plugin) {
        String testOwnerId = Objects.requireNonNull(plugin, "plugin").metadata().id();
        Set<ScheduledTask> allTasks = this.tasks();
        Iterator<ScheduledTask> it = allTasks.iterator();
        while (it.hasNext()) {
            String taskOwnerId = it.next().task().plugin().metadata().id();
            if (testOwnerId.equals(taskOwnerId)) continue;
            it.remove();
        }
        return allTasks;
    }

    @Override
    public SpongeTaskExecutorService executor(PluginContainer plugin) {
        Objects.requireNonNull(plugin, "plugin");
        return new SpongeTaskExecutorService(() -> Task.builder().plugin(plugin), this);
    }

    @Override
    public SpongeScheduledTask submit(Task task) {
        Objects.requireNonNull(task, "task");
        String name = task.plugin().metadata().id() + "-" + TASK_CREATED_COUNTER.incrementAndGet();
        return this.submit(task, name);
    }

    @Override
    public SpongeScheduledTask submit(Task task, String name) {
        Objects.requireNonNull(task, "task");
        if (Objects.requireNonNull(name, "name").isEmpty()) {
            throw new IllegalArgumentException("Task name cannot empty!");
        }
        SpongeScheduledTask scheduledTask = new SpongeScheduledTask(this, (SpongeTask)task, name + "-" + this.tag + "-#" + this.sequenceNumber++);
        this.addTask(scheduledTask);
        return scheduledTask;
    }

    final void runTick() {
        this.preTick();
        try {
            this.tasks.values().forEach(this::processTask);
            this.postTick();
        }
        finally {
            this.finallyPostTick();
        }
    }

    protected void preTick() {
    }

    protected void postTick() {
    }

    protected void finallyPostTick() {
    }

    private void processTask(SpongeScheduledTask task) {
        boolean tickBased;
        long threshold;
        if (task.state() == SpongeScheduledTask.ScheduledTaskState.CANCELED) {
            this.removeTask(task);
            return;
        }
        if (task.state() == SpongeScheduledTask.ScheduledTaskState.EXECUTING) {
            return;
        }
        if (task.state() == SpongeScheduledTask.ScheduledTaskState.WAITING) {
            threshold = task.task.delay;
            tickBased = task.task.tickBasedDelay;
        } else if (task.state() == SpongeScheduledTask.ScheduledTaskState.RUNNING) {
            threshold = task.task.interval;
            tickBased = task.task.tickBasedInterval;
        } else {
            threshold = Long.MAX_VALUE;
            tickBased = false;
        }
        long now = this.timestamp(tickBased);
        if (threshold <= now - task.timestamp()) {
            task.setState(SpongeScheduledTask.ScheduledTaskState.SWITCHING);
            task.setTimestamp(this.timestamp(task.task.tickBasedInterval));
            this.startTask(task);
            if (task.task.interval == 0L) {
                this.removeTask(task);
            }
        }
    }

    private void startTask(SpongeScheduledTask task) {
        this.executeRunnable(() -> {
            task.setState(SpongeScheduledTask.ScheduledTaskState.EXECUTING);
            try (@Nullable PhaseContext<@NonNull ?> context = this.createContext(task, task.task().plugin());){
                if (context != null) {
                    context.buildAndSwitch();
                }
                try {
                    task.task.executor().accept(task);
                }
                catch (Throwable t2) {
                    SpongeCommon.logger().error("The Scheduler tried to run the task '{}' owned by '{}' but an error occurred.", (Object)task.name(), (Object)task.task().plugin().metadata().id(), (Object)t2);
                }
            }
            finally {
                if (!task.isCancelled()) {
                    task.setState(SpongeScheduledTask.ScheduledTaskState.RUNNING);
                }
                this.onTaskCompletion(task);
            }
        });
    }

    protected @Nullable PhaseContext<?> createContext(SpongeScheduledTask task, PluginContainer plugin) {
        return ((BasicPluginContext)PluginPhase.State.SCHEDULED_TASK.createPhaseContext(PhaseTracker.getInstance()).source(task)).container(plugin);
    }

    protected void onTaskCompletion(SpongeScheduledTask task) {
    }

    protected void executeRunnable(Runnable runnable) {
        runnable.run();
    }

    public <V> Future<V> execute(Callable<V> callable) {
        FutureTask<V> runnable = new FutureTask<V>(callable);
        this.submit(new SpongeTask.BuilderImpl().execute(runnable).plugin(((Launch)Launch.instance()).commonPlugin()).build());
        return runnable;
    }

    public Future<?> execute(Runnable runnable) {
        return this.execute(() -> {
            runnable.run();
            return null;
        });
    }
}

