/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeTask
implements Task {
    private final PluginContainer plugin;
    private final Consumer<ScheduledTask> executor;
    final long delay;
    final long interval;
    final boolean tickBasedDelay;
    final boolean tickBasedInterval;

    SpongeTask(PluginContainer plugin, Consumer<ScheduledTask> executor, long delay, long interval, boolean tickBasedDelay, boolean tickBasedInterval) {
        this.plugin = plugin;
        this.executor = executor;
        this.delay = delay;
        this.interval = interval;
        this.tickBasedDelay = tickBasedDelay;
        this.tickBasedInterval = tickBasedInterval;
    }

    @Override
    public PluginContainer plugin() {
        return this.plugin;
    }

    @Override
    public Duration delay() {
        return Duration.ofNanos(this.delay);
    }

    @Override
    public Duration interval() {
        return Duration.ofNanos(this.interval);
    }

    public Consumer<ScheduledTask> executor() {
        return this.executor;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("plugin", (Object)this.plugin.metadata().id()).add("delay", this.delay).add("interval", this.interval).toString();
    }

    public static final class BuilderImpl
    implements Task.Builder {
        private @Nullable Consumer<ScheduledTask> executor;
        private @Nullable PluginContainer plugin;
        private long delay;
        private long interval;
        private boolean tickBasedDelay;
        private boolean tickBasedInterval;

        @Override
        public Task.Builder execute(Consumer<ScheduledTask> executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        @Override
        public Task.Builder delay(long delay, TemporalUnit unit) {
            Objects.requireNonNull(unit);
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder delay(long delay, TimeUnit unit) {
            Objects.requireNonNull(unit);
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = Objects.requireNonNull(unit, "unit").toNanos(delay);
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder delay(Ticks delay) {
            Objects.requireNonNull(delay);
            if (delay.ticks() < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = delay.ticks() * SpongeScheduler.TICK_DURATION_NS;
            this.tickBasedDelay = true;
            return this;
        }

        @Override
        public Task.Builder delay(Duration delay) {
            this.delay = Objects.requireNonNull(delay, "delay").toNanos();
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder interval(Duration interval) {
            this.interval = Objects.requireNonNull(interval, "interval").toNanos();
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(long delay, TemporalUnit unit) {
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.interval = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(long interval, TimeUnit unit) {
            if (interval < 0L) {
                throw new IllegalArgumentException("Interval must be equal to or greater than zero!");
            }
            this.interval = Objects.requireNonNull(unit, "unit").toNanos(interval);
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(Ticks interval) {
            Objects.requireNonNull(interval, "interval");
            if (interval.ticks() < 0L) {
                throw new IllegalArgumentException("Interval must be equal to or greater than zero!");
            }
            this.interval = interval.ticks() * SpongeScheduler.TICK_DURATION_NS;
            this.tickBasedInterval = true;
            return this;
        }

        @Override
        public Task.Builder plugin(PluginContainer plugin) {
            this.plugin = Objects.requireNonNull(plugin);
            return this;
        }

        @Override
        public Task.Builder from(Task value) {
            SpongeTask task = (SpongeTask)Objects.requireNonNull(value, "value");
            this.executor = task.executor;
            this.plugin = task.plugin();
            this.interval = task.interval;
            this.delay = task.delay;
            this.tickBasedDelay = task.tickBasedDelay;
            this.tickBasedInterval = task.tickBasedInterval;
            return this;
        }

        @Override
        public Task.Builder reset() {
            this.executor = null;
            this.plugin = null;
            this.interval = 0L;
            this.delay = 0L;
            this.tickBasedDelay = false;
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task build() {
            Objects.requireNonNull(this.executor, "executor");
            Objects.requireNonNull(this.plugin, "plugin");
            return new SpongeTask(this.plugin, this.executor, this.delay, this.interval, this.tickBasedDelay, this.tickBasedInterval);
        }
    }
}

