/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.Optional;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlot
implements DisplaySlot {
    private final int id;
    private final @Nullable TextFormatting formatting;
    private @Nullable NamedTextColor color;

    public static int slotIdFromFormatting(TextFormatting formatting) {
        return formatting.func_175746_b() + 3;
    }

    public SpongeDisplaySlot(int id) {
        this(id, null);
    }

    public SpongeDisplaySlot(TextFormatting color) {
        this(SpongeDisplaySlot.slotIdFromFormatting(color), color);
    }

    private SpongeDisplaySlot(int id, @Nullable TextFormatting color) {
        this.id = id;
        this.formatting = color;
    }

    @Override
    public @NonNull Optional<NamedTextColor> teamColor() {
        if (this.color == null) {
            this.color = SpongeAdventure.asAdventureNamed(this.formatting);
        }
        return Optional.ofNullable(this.color);
    }

    public int index() {
        return this.id;
    }
}

