/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlotFactory
implements DisplaySlot.Factory {
    @Override
    public @NonNull Optional<DisplaySlot> findByTeamColor(@NonNull NamedTextColor color) {
        DefaultedRegistryReference<DisplaySlot> slot = ColorMapping.COLOR_TO_DISPLAY_SLOT_MAP.get(SpongeAdventure.asVanilla(color));
        if (slot != null) {
            return slot.find();
        }
        return Optional.empty();
    }

    public static final class ColorMapping {
        public static final Map<TextFormatting, DefaultedRegistryReference<DisplaySlot>> COLOR_TO_DISPLAY_SLOT_MAP;

        private ColorMapping() {
        }

        static {
            HashMap<TextFormatting, DefaultedRegistryReference<DisplaySlot>> map = new HashMap<TextFormatting, DefaultedRegistryReference<DisplaySlot>>();
            map.put(TextFormatting.AQUA, DisplaySlots.SIDEBAR_TEAM_AQUA);
            map.put(TextFormatting.BLACK, DisplaySlots.SIDEBAR_TEAM_BLACK);
            map.put(TextFormatting.BLUE, DisplaySlots.SIDEBAR_TEAM_BLUE);
            map.put(TextFormatting.DARK_AQUA, DisplaySlots.SIDEBAR_TEAM_DARK_AQUA);
            map.put(TextFormatting.DARK_BLUE, DisplaySlots.SIDEBAR_TEAM_DARK_BLUE);
            map.put(TextFormatting.DARK_GRAY, DisplaySlots.SIDEBAR_TEAM_DARK_GRAY);
            map.put(TextFormatting.DARK_GREEN, DisplaySlots.SIDEBAR_TEAM_DARK_GREEN);
            map.put(TextFormatting.DARK_PURPLE, DisplaySlots.SIDEBAR_TEAM_DARK_PURPLE);
            map.put(TextFormatting.DARK_RED, DisplaySlots.SIDEBAR_TEAM_DARK_RED);
            map.put(TextFormatting.GOLD, DisplaySlots.SIDEBAR_TEAM_GOLD);
            map.put(TextFormatting.GRAY, DisplaySlots.SIDEBAR_TEAM_GRAY);
            map.put(TextFormatting.GREEN, DisplaySlots.SIDEBAR_TEAM_GREEN);
            map.put(TextFormatting.LIGHT_PURPLE, DisplaySlots.SIDEBAR_TEAM_LIGHT_PURPLE);
            map.put(TextFormatting.RED, DisplaySlots.SIDEBAR_TEAM_RED);
            map.put(TextFormatting.WHITE, DisplaySlots.SIDEBAR_TEAM_WHITE);
            map.put(TextFormatting.YELLOW, DisplaySlots.SIDEBAR_TEAM_YELLOW);
            COLOR_TO_DISPLAY_SLOT_MAP = Collections.unmodifiableMap(map);
        }
    }
}

