/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.common.accessor.world.scores.ObjectiveAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeScore;

public final class SpongeObjective
implements Objective {
    private final String name;
    private final Criterion criterion;
    private final Map<Component, Score> scores = new HashMap<Component, Score>();
    private final Map<net.minecraft.scoreboard.Scoreboard, ScoreObjective> objectives;
    private Component displayName;
    private ObjectiveDisplayMode displayMode;

    public SpongeObjective(String name, Criterion criterion) {
        this.name = name;
        this.displayName = LegacyComponentSerializer.legacySection().deserialize(name);
        this.displayMode = ObjectiveDisplayModes.INTEGER.get();
        this.criterion = criterion;
        this.objectives = new HashMap<net.minecraft.scoreboard.Scoreboard, ScoreObjective>();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Component displayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(Component displayName) throws IllegalArgumentException {
        this.displayName = displayName;
        this.updateDisplayName();
    }

    public void storeDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    @Override
    public Criterion criterion() {
        return this.criterion;
    }

    @Override
    public ObjectiveDisplayMode displayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.updateDisplayMode();
    }

    public void storeDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public Map<Component, Score> scores() {
        return new HashMap<Component, Score>(this.scores);
    }

    @Override
    public boolean hasScore(Component name) {
        return this.scores.containsKey(name);
    }

    @Override
    public void addScore(Score score) throws IllegalArgumentException {
        if (this.scores.containsKey(score.name())) {
            throw new IllegalArgumentException(String.format("A score with the name %s already exists!", LegacyComponentSerializer.legacySection().serialize(score.name())));
        }
        this.scores.put(score.name(), score);
        SpongeScore spongeScore = (SpongeScore)score;
        for (ScoreObjective objective : this.objectives.values()) {
            this.addScoreToScoreboard(((ObjectiveAccessor)objective).accessor$scoreboard(), spongeScore.getScoreFor(objective));
        }
    }

    @Override
    public Optional<Score> findScore(Component name) {
        return Optional.ofNullable(this.scores.get(name));
    }

    @Override
    public Score findOrCreateScore(Component name) {
        if (this.scores.containsKey(name)) {
            return this.scores.get(name);
        }
        SpongeScore score = new SpongeScore(name);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean removeScore(Score spongeScore) {
        String name = ((SpongeScore)spongeScore).legacyName;
        if (!this.scores.containsKey(spongeScore.name())) {
            return false;
        }
        for (ScoreObjective objective : this.objectives.values()) {
            net.minecraft.scoreboard.Scoreboard scoreboard = ((ObjectiveAccessor)objective).accessor$scoreboard();
            Map<ScoreObjective, net.minecraft.scoreboard.Score> map = ((ScoreboardAccessor)scoreboard).accessor$playerScores().get(name);
            if (map != null) {
                net.minecraft.scoreboard.Score score = map.remove(objective);
                if (map.size() < 1) {
                    Map<ScoreObjective, net.minecraft.scoreboard.Score> map1 = ((ScoreboardAccessor)scoreboard).accessor$playerScores().remove(name);
                    if (map1 != null) {
                        scoreboard.func_96516_a(name);
                    }
                } else if (score != null) {
                    scoreboard.func_178820_a(name, objective);
                }
            }
            ((SpongeScore)spongeScore).removeScoreFor(objective);
        }
        this.scores.remove(spongeScore.name());
        return true;
    }

    @Override
    public boolean removeScore(Component name) {
        Optional<Score> score = this.findScore(name);
        return score.filter(this::removeScore).isPresent();
    }

    @Override
    public Set<Scoreboard> scoreboards() {
        return new HashSet<net.minecraft.scoreboard.Scoreboard>(this.objectives.keySet());
    }

    private void updateDisplayMode() {
        for (ScoreObjective objective : this.objectives.values()) {
            objective.func_199866_a((ScoreCriteria.RenderType)this.displayMode);
        }
    }

    private void updateDisplayName() {
        for (ScoreObjective objective : this.objectives.values()) {
            objective.func_199864_a(SpongeAdventure.asVanilla(this.displayName));
        }
    }

    public void updateScores(net.minecraft.scoreboard.Scoreboard scoreboard) {
        ScoreObjective objective = this.getObjectiveFor(scoreboard);
        for (Score score : this.scores().values()) {
            SpongeScore spongeScore = (SpongeScore)score;
            this.addScoreToScoreboard(scoreboard, spongeScore.getScoreFor(objective));
        }
    }

    private void addScoreToScoreboard(net.minecraft.scoreboard.Scoreboard scoreboard, net.minecraft.scoreboard.Score score) {
        String name = score.func_96653_e();
        Map scoreMap = ((ScoreboardAccessor)scoreboard).accessor$playerScores().computeIfAbsent(name, k -> Maps.newHashMap());
        scoreMap.put(((ScoreAccessor)score).accessor$objective(), score);
        ((ScoreAccessor)score).accessor$forceUpdate(true);
        score.func_96647_c(((ScoreAccessor)score).accessor$count());
    }

    public ScoreObjective getObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.containsKey(scoreboard)) {
            return this.objectives.get(scoreboard);
        }
        ScoreObjective objective = new ScoreObjective(scoreboard, this.name, (ScoreCriteria)this.criterion, SpongeAdventure.asVanilla(this.displayName), (ScoreCriteria.RenderType)this.displayMode);
        ((ObjectiveBridge)objective).bridge$setSpongeObjective(this);
        this.objectives.put(scoreboard, objective);
        return objective;
    }

    public void removeObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.remove(scoreboard) == null) {
            throw new IllegalStateException("Attempting to remove an objective without an entry!");
        }
    }

    public Collection<ScoreObjective> getObjectives() {
        return this.objectives.values();
    }

    public static final class Builder
    implements Objective.Builder {
        private static final int MAX_NAME_LENGTH = 16;
        private @Nullable String name;
        private @Nullable Component displayName;
        private @Nullable Criterion criterion;
        private @Nullable ObjectiveDisplayMode objectiveDisplayMode;

        @Override
        public Objective.Builder name(String name) {
            Objects.requireNonNull(name);
            if (16 < name.length()) {
                throw new IllegalStateException(String.format("name '%s' is too long: %s characters over limit of %s", name, 16 - name.length(), 16));
            }
            this.name = name;
            return this;
        }

        @Override
        public Objective.Builder displayName(Component displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        @Override
        public Objective.Builder criterion(Criterion criterion) {
            this.criterion = Objects.requireNonNull(criterion);
            return this;
        }

        @Override
        public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
            this.objectiveDisplayMode = Objects.requireNonNull(objectiveDisplayMode);
            return this;
        }

        @Override
        public Objective.Builder from(Objective value) {
            Objects.requireNonNull(value);
            this.name = value.name();
            this.displayName = value.displayName();
            this.criterion = value.criterion();
            this.objectiveDisplayMode = value.displayMode();
            return this;
        }

        @Override
        public Builder reset() {
            this.name = null;
            this.displayName = null;
            this.criterion = null;
            this.objectiveDisplayMode = null;
            return this;
        }

        @Override
        public Objective build() {
            if (this.name == null) {
                throw new IllegalStateException("Name cannot be null!");
            }
            if (this.criterion == null) {
                throw new IllegalStateException("Criterion cannot be null!");
            }
            SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
            if (this.displayName != null) {
                objective.setDisplayName(this.displayName);
            }
            if (this.objectiveDisplayMode != null) {
                objective.setDisplayMode(this.objectiveDisplayMode);
            } else if (this.criterion instanceof ScoreCriteria) {
                objective.setDisplayMode((ObjectiveDisplayMode)((ScoreCriteria)this.criterion).func_178790_c());
            }
            return objective;
        }
    }
}

