/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.scoreboard.ScoreObjective;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.common.accessor.world.scores.ObjectiveAccessor;
import org.spongepowered.common.accessor.world.scores.ScoreAccessor;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.bridge.world.scores.ScoreBridge;

public final class SpongeScore
implements Score {
    private final Component name;
    public String legacyName;
    private int score;
    private boolean locked;
    private final Map<ScoreObjective, net.minecraft.scoreboard.Score> scores = new HashMap<ScoreObjective, net.minecraft.scoreboard.Score>();

    public SpongeScore(Component name) {
        this.name = name;
        this.legacyName = LegacyComponentSerializer.legacySection().serialize(name);
        if (this.legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("The score name %s is too long! It must be at most %s characters.", this.legacyName, 40));
        }
    }

    @Override
    public Component name() {
        return this.name;
    }

    @Override
    public int score() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
        this.updateScore();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    private void updateScore() {
        for (net.minecraft.scoreboard.Score score : this.scores.values()) {
            int j = ((ScoreAccessor)score).accessor$count();
            ((ScoreAccessor)score).accessor$count(this.score);
            if (j == this.score && !((ScoreAccessor)score).accessor$forceUpdate()) continue;
            ((ScoreAccessor)score).accessor$forceUpdate(false);
            score.func_96650_f().func_96536_a(score);
        }
    }

    @Override
    public Set<Objective> objectives() {
        HashSet<Objective> objectives = new HashSet<Objective>();
        for (ScoreObjective objective : this.scores.keySet()) {
            objectives.add(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return objectives;
    }

    public net.minecraft.scoreboard.Score getScoreFor(ScoreObjective objective) {
        if (this.scores.containsKey(objective)) {
            return this.scores.get(objective);
        }
        net.minecraft.scoreboard.Score score = new net.minecraft.scoreboard.Score(((ObjectiveAccessor)objective).accessor$scoreboard(), objective, this.legacyName);
        ((ScoreAccessor)score).accessor$count(this.score);
        ((ScoreBridge)score).bridge$setSpongeScore(this);
        this.scores.put(objective, score);
        return score;
    }

    public void removeScoreFor(ScoreObjective objective) {
        if (this.scores.remove(objective) == null) {
            throw new IllegalStateException("Attempting to remove an score without an entry!");
        }
    }
}

