/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.context;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.context.ContextService;
import org.spongepowered.common.event.tracking.PhaseTracker;

public class SpongeContextService
implements ContextService {
    private final List<ContextCalculator> calculator = new CopyOnWriteArrayList<ContextCalculator>();

    @Inject
    SpongeContextService() {
    }

    @Override
    public @NonNull Set<Context> contexts() {
        return this.contextsFor(PhaseTracker.getInstance().currentCause());
    }

    @Override
    public @NonNull Set<Context> contextsFor(@NonNull Cause cause) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        Consumer<Context> accumulator = arg_0 -> ((ImmutableSet.Builder)result).add(arg_0);
        for (ContextCalculator calc : this.calculator) {
            calc.accumulateContexts(cause, accumulator);
        }
        return result.build();
    }

    @Override
    public void registerContextCalculator(@NonNull ContextCalculator calculator) {
        this.calculator.add(calculator);
    }
}

