/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.NodeTree;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.service.permission.TransferMethod;
import org.spongepowered.api.util.Tristate;

public class MemorySubjectData
implements SubjectData {
    protected final Subject subject;
    protected final ConcurrentMap<Set<Context>, Map<String, String>> options = new ConcurrentHashMap<Set<Context>, Map<String, String>>();
    protected final ConcurrentMap<Set<Context>, NodeTree> permissions = new ConcurrentHashMap<Set<Context>, NodeTree>();
    protected final ConcurrentMap<Set<Context>, List<SubjectReference>> parents = new ConcurrentHashMap<Set<Context>, List<SubjectReference>>();

    public MemorySubjectData(Subject subject) {
        this.subject = Objects.requireNonNull(subject, "subject");
    }

    protected void onUpdate() {
    }

    @Override
    public Subject subject() {
        return this.subject;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Map<Set<Context>, Map<String, Boolean>> allPermissions() {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        for (Map.Entry ent : this.permissions.entrySet()) {
            ret.put((Object)((Set)ent.getKey()), ((NodeTree)ent.getValue()).asMap());
        }
        return ret.build();
    }

    public NodeTree nodeTree(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(Objects.requireNonNull(contexts, "contexts"));
        return perms == null ? NodeTree.of(Collections.emptyMap()) : perms;
    }

    @Override
    public Map<String, Boolean> permissions(Set<Context> contexts) {
        NodeTree perms = (NodeTree)this.permissions.get(Objects.requireNonNull(contexts, "contexts"));
        return perms == null ? ImmutableMap.of() : perms.asMap();
    }

    @Override
    public CompletableFuture<Boolean> setPermission(Set<Context> contexts, String permission, Tristate value) {
        NodeTree oldTree;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(value, "value");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldTree = (NodeTree)this.permissions.get(contexts)) == null || oldTree.get(permission) != value) continue;
            return CompletableFuture.completedFuture(false);
        } while (!(oldTree == null && value != Tristate.UNDEFINED ? this.permissions.putIfAbsent((Set<Context>)contexts, NodeTree.of(Collections.singletonMap(permission, value.asBoolean()))) == null : oldTree == null || this.permissions.replace((Set<Context>)contexts, oldTree, oldTree.withValue(permission, value))));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Boolean> setPermissions(Set<Context> contexts, Map<String, Boolean> permissions, TransferMethod method) {
        contexts = ImmutableSet.copyOf((Collection)Objects.requireNonNull(contexts, "contexts"));
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(permissions, "permissions");
        block4: while (true) {
            oldTree = (NodeTree)this.permissions.get(contexts);
            switch (1.$SwitchMap$org$spongepowered$api$service$permission$TransferMethod[method.ordinal()]) {
                case 1: {
                    newTree = oldTree != null ? oldTree.withAll(permissions) : NodeTree.of(permissions);
                    if (!this.updateCollection(this.permissions, contexts, oldTree, newTree)) continue block4;
                    break block4;
                }
                case 2: {
                    if (this.updateCollection(this.permissions, contexts, oldTree, NodeTree.of(permissions))) ** break;
                    continue block4;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled enum state " + (Object)method);
                }
            }
            break;
        }
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public Tristate fallbackPermissionValue(Set<Context> contexts) {
        NodeTree tree = (NodeTree)this.permissions.get(Objects.requireNonNull(contexts, "contexts"));
        return tree == null ? Tristate.UNDEFINED : tree.rootValue();
    }

    @Override
    public Map<Set<Context>, Tristate> allFallbackPermissionValues() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.permissions.entrySet()) {
            builder.put((Object)((Set)entry.getKey()), (Object)((NodeTree)entry.getValue()).rootValue());
        }
        return builder.build();
    }

    @Override
    public CompletableFuture<Boolean> setFallbackPermissionValue(Set<Context> contexts, Tristate fallback) {
        NodeTree oldTree;
        contexts = ImmutableSet.copyOf((Collection)Objects.requireNonNull(contexts, "contexts"));
        Objects.requireNonNull(fallback, "fallback");
        do {
            if ((oldTree = (NodeTree)this.permissions.get(contexts)) == null || oldTree.rootValue() != fallback) continue;
            return CompletableFuture.completedFuture(false);
        } while (!(oldTree == null && fallback != Tristate.UNDEFINED ? this.permissions.putIfAbsent((Set<Context>)contexts, NodeTree.of((Map<String, Boolean>)ImmutableMap.of(), fallback)) == null : oldTree == null || this.permissions.replace((Set<Context>)contexts, oldTree, oldTree.withRootValue(fallback))));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearFallbackPermissionValues() {
        boolean anyUpdated = false;
        for (Set key : this.permissions.keySet()) {
            NodeTree oldTree;
            while ((oldTree = (NodeTree)this.permissions.get(key)) == null || oldTree.rootValue() == Tristate.UNDEFINED || !this.updateCollection(this.permissions, key, oldTree, oldTree.withRootValue(Tristate.UNDEFINED))) {
            }
            anyUpdated = true;
        }
        this.onUpdate();
        return CompletableFuture.completedFuture(anyUpdated);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions() {
        boolean wasEmpty = this.permissions.isEmpty();
        this.permissions.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearPermissions(Set<Context> context) {
        boolean changed;
        boolean bl = changed = this.permissions.remove(Objects.requireNonNull(context, "context")) != null;
        if (changed) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(changed);
    }

    public Map<Set<Context>, List<? extends SubjectReference>> allParents() {
        return ImmutableMap.copyOf(this.parents);
    }

    public List<SubjectReference> parents(Set<Context> contexts) {
        return this.parents.getOrDefault(Objects.requireNonNull(contexts, "contexts"), (List<SubjectReference>)ImmutableList.of());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Boolean> setParents(Set<Context> contexts, List<? extends SubjectReference> parents, TransferMethod method) {
        contexts = ImmutableSet.copyOf((Collection)Objects.requireNonNull(contexts, "contexts"));
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(parents, "parents");
        block4: while (true) {
            oldParents = (List)this.parents.get(contexts);
            switch (1.$SwitchMap$org$spongepowered$api$service$permission$TransferMethod[method.ordinal()]) {
                case 1: {
                    if (oldParents != null) {
                        newParents = new ArrayList<SubjectReference>(oldParents);
                        newParents.removeAll(parents);
                        newParents.addAll(parents);
                        if (!this.parents.replace((Set<Context>)contexts, oldParents, newParents)) continue block4;
                        break block4;
                    }
                    if (this.parents.putIfAbsent((Set<Context>)contexts, (List<SubjectReference>)ImmutableList.copyOf(parents)) != null) continue block4;
                    break block4;
                }
                case 2: {
                    if (this.parents.replace((Set<Context>)contexts, oldParents, (List<SubjectReference>)ImmutableList.copyOf(parents))) ** break;
                    continue block4;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled enum state " + (Object)method);
                }
            }
            break;
        }
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> addParent(Set<Context> contexts, SubjectReference parent) {
        ImmutableList newParents;
        List oldParents;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(parent, "parent");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldParents = (List)this.parents.get(contexts)) == null || !oldParents.contains(parent)) continue;
            return CompletableFuture.completedFuture(false);
        } while (!this.updateCollection(this.parents, contexts, oldParents, newParents = ImmutableList.builder().addAll((Iterable)(oldParents == null ? ImmutableList.of() : oldParents)).add((Object)parent).build()));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    private <K, V> boolean updateCollection(ConcurrentMap<K, V> collection, K key, @Nullable V oldValue, @Nullable V newValue) {
        if (newValue == null) {
            return oldValue == null ? !collection.containsKey(key) : collection.remove(key, oldValue);
        }
        if (oldValue == null) {
            return collection.putIfAbsent(key, newValue) == null;
        }
        return collection.replace(key, oldValue, newValue);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(Set<Context> contexts, SubjectReference parent) {
        ArrayList newParents;
        List oldParents;
        Objects.requireNonNull(contexts, "contexts");
        Objects.requireNonNull(parent, "parent");
        contexts = ImmutableSet.copyOf(contexts);
        do {
            if ((oldParents = (List)this.parents.get(contexts)) == null || !oldParents.contains(parent)) {
                return CompletableFuture.completedFuture(false);
            }
            newParents = new ArrayList(oldParents);
            newParents.remove(parent);
        } while (!this.updateCollection(this.parents, contexts, oldParents, ImmutableList.copyOf(newParents)));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearParents() {
        boolean wasEmpty = this.parents.isEmpty();
        this.parents.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearParents(Set<Context> contexts) {
        boolean changed;
        boolean bl = changed = this.parents.remove(Objects.requireNonNull(contexts, "contexts")) != null;
        if (changed) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(changed);
    }

    @Override
    public Map<Set<Context>, Map<String, String>> allOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    @Override
    public Map<String, String> options(Set<Context> contexts) {
        return this.options.getOrDefault(Objects.requireNonNull(contexts, "contexts"), Collections.emptyMap());
    }

    @Override
    public CompletableFuture<Boolean> setOption(Set<Context> contexts, String key, @Nullable String value) {
        ImmutableMap newMap;
        contexts = ImmutableSet.copyOf((Collection)Objects.requireNonNull(contexts, "contexts"));
        Objects.requireNonNull(key, "key");
        @Nullable Map<String, String> origMap = (Map<String, String>)this.options.get(contexts);
        if (origMap == null) {
            if (value == null) {
                return CompletableFuture.completedFuture(false);
            }
            origMap = this.options.putIfAbsent((Set<Context>)contexts, Collections.singletonMap(key.toLowerCase(), value));
            if (origMap == null) {
                this.onUpdate();
                return CompletableFuture.completedFuture(true);
            }
        }
        do {
            if (value == null) {
                if (!origMap.containsKey(key)) {
                    return CompletableFuture.completedFuture(false);
                }
                newMap = new HashMap(origMap);
                newMap.remove(key);
                continue;
            }
            newMap = new HashMap(origMap);
            newMap.put(key, value);
        } while (!this.options.replace((Set<Context>)contexts, origMap, (Map<String, String>)(newMap = ImmutableMap.copyOf(newMap))));
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Boolean> setOptions(Set<Context> contexts, Map<String, String> options, TransferMethod method) {
        contexts = ImmutableSet.copyOf((Collection)Objects.requireNonNull(contexts, "contexts"));
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(options, "options");
        block4: while (true) {
            oldOptions = (Map)this.options.get(contexts);
            switch (1.$SwitchMap$org$spongepowered$api$service$permission$TransferMethod[method.ordinal()]) {
                case 1: {
                    newOptions = oldOptions == null ? new HashMap<String, String>() : new HashMap<K, V>(oldOptions);
                    newOptions.putAll(options);
                    if (!this.updateCollection(this.options, contexts, oldOptions, newOptions)) continue block4;
                    break block4;
                }
                case 2: {
                    if (this.updateCollection(this.options, contexts, oldOptions, ImmutableMap.copyOf(options))) ** break;
                    continue block4;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled enum state " + (Object)method);
                }
            }
            break;
        }
        this.onUpdate();
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions() {
        boolean wasEmpty = this.options.isEmpty();
        this.options.clear();
        if (!wasEmpty) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(!wasEmpty);
    }

    @Override
    public CompletableFuture<Boolean> clearOptions(Set<Context> contexts) {
        boolean ret;
        boolean bl = ret = this.options.remove(Objects.requireNonNull(contexts, "contexts")) != null;
        if (ret) {
            this.onUpdate();
        }
        return CompletableFuture.completedFuture(ret);
    }

    @Override
    public CompletableFuture<Boolean> copyFrom(SubjectData other, TransferMethod method) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(method, "method");
        Map<Set<Context>, Map<String, Boolean>> otherPerms = other.allPermissions();
        Map<Set<Context>, Map<String, String>> otherOptions = other.allOptions();
        Map<Set<Context>, ? extends List<? extends SubjectReference>> otherParents = other.allParents();
        if (method == TransferMethod.OVERWRITE) {
            this.permissions.clear();
            this.parents.clear();
            this.options.clear();
        }
        otherPerms.forEach((ctx, permissions) -> this.setPermissions((Set<Context>)ctx, (Map<String, Boolean>)permissions, method));
        otherOptions.forEach((ctx, options) -> this.setOptions((Set<Context>)ctx, (Map<String, String>)options, method));
        otherParents.forEach((ctx, parents) -> this.setParents((Set<Context>)ctx, (List<? extends SubjectReference>)parents, method));
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> moveFrom(SubjectData other, TransferMethod method) {
        return this.copyFrom(other, method).thenCompose(res -> CompletableFuture.allOf(other.clearOptions(), other.clearParents(), other.clearPermissions()).thenApply(x -> res));
    }
}

