/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.whitelist;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.whitelist.WhitelistService;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.players.StoredUserEntryAccessor;
import org.spongepowered.common.accessor.server.players.StoredUserListAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeWhitelistService
implements WhitelistService {
    @Override
    public CompletableFuture<Collection<GameProfile>> whitelistedProfiles() {
        ArrayList<SpongeGameProfile> profiles = new ArrayList<SpongeGameProfile>();
        WhiteList list = SpongeCommon.server().func_184103_al().func_152599_k();
        for (WhitelistEntry entry : ((StoredUserListAccessor)list).accessor$map().values()) {
            profiles.add(SpongeGameProfile.of((com.mojang.authlib.GameProfile)((StoredUserEntryAccessor)entry).accessor$user()));
        }
        return CompletableFuture.completedFuture(profiles);
    }

    @Override
    public CompletableFuture<Boolean> isWhitelisted(GameProfile profile) {
        StoredUserListAccessor whitelist = (StoredUserListAccessor)SpongeWhitelistService.getWhitelist();
        whitelist.invoker$removeExpired();
        return CompletableFuture.completedFuture(whitelist.accessor$map().containsKey(whitelist.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile))));
    }

    @Override
    public CompletableFuture<Boolean> addProfile(GameProfile profile) {
        boolean wasWhitelisted = UserListUtil.addEntry(SpongeWhitelistService.getWhitelist(), (UserListEntry)new WhitelistEntry(SpongeGameProfile.toMcProfile(profile))) != null;
        return CompletableFuture.completedFuture(wasWhitelisted);
    }

    @Override
    public CompletableFuture<Boolean> removeProfile(GameProfile profile) {
        boolean wasWhitelisted = UserListUtil.removeEntry(SpongeWhitelistService.getWhitelist(), SpongeGameProfile.toMcProfile(profile)) != null;
        return CompletableFuture.completedFuture(wasWhitelisted);
    }

    private static WhiteList getWhitelist() {
        return SpongeCommon.server().func_184103_al().func_152599_k();
    }
}

