/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.KeyValueMatcher;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateContainer;
import org.spongepowered.api.state.StateMatcher;
import org.spongepowered.api.state.StateProperty;

public abstract class AbstractSpongeStateMatcher<S extends State<@NonNull S>, T extends StateContainer<@NonNull S>>
implements StateMatcher<S> {
    final T type;
    final Map<StateProperty<@NonNull ?>, Object> properties;
    final Collection<KeyValueMatcher<?>> keyValueMatchers;
    final Collection<StateProperty<@NonNull ?>> requiredProperties;
    protected @MonotonicNonNull List<S> compatibleStates;

    AbstractSpongeStateMatcher(T type, Collection<StateProperty<@NonNull ?>> requiredProperties, HashMap<StateProperty<@NonNull ?>, Object> properties, Collection<KeyValueMatcher<?>> keyValueMatchers) {
        this.type = type;
        this.requiredProperties = requiredProperties;
        this.properties = properties;
        this.keyValueMatchers = keyValueMatchers;
    }

    protected final boolean isValid(StateHolder<?, ?> stateHolder) {
        Property property;
        for (Map.Entry<StateProperty<?>, Object> entry : this.properties.entrySet()) {
            property = (Property)entry.getKey();
            Object value = stateHolder.func_206871_b().get((Object)property);
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        for (StateProperty stateProperty : this.requiredProperties) {
            property = (Property)stateProperty;
            if (stateHolder.func_206871_b().get((Object)property) != null) continue;
            return false;
        }
        DataHolder dataHolder = (DataHolder)stateHolder;
        for (KeyValueMatcher<?> valueMatcher : this.keyValueMatchers) {
            if (this.matches(dataHolder, valueMatcher)) continue;
            return false;
        }
        return true;
    }

    private <V> boolean matches(DataHolder holder, KeyValueMatcher<V> keyValueMatcher) {
        return holder.get(keyValueMatcher.key()).map(keyValueMatcher::matches).orElse(false);
    }
}

