/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.user;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.PlayerData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.user.UserManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.players.PlayerListAccessor;
import org.spongepowered.common.accessor.world.level.storage.PlayerDataStorageAccessor;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.user.SpongeUserMutableWatchEvent;

public final class SpongeUserManager
implements UserManager {
    public static final UUID FAKEPLAYER_UUID = UUID.fromString("41C82C87-7AFB-4024-BA57-13D2C99CAE77");
    private final Set<UUID> knownUUIDs = new HashSet<UUID>();
    private final Cache<UUID, SpongeUserData> userCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final Set<SpongeUserData> dirtyUsers = ConcurrentHashMap.newKeySet();
    private final Map<String, SpongeUserMutableWatchEvent> watcherUpdateMap = new HashMap<String, SpongeUserMutableWatchEvent>();
    private final MinecraftServer server;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Sponge-User-Data-Loader").build());
    private @Nullable WatchService filesystemWatchService = null;
    private @Nullable WatchKey watchKey = null;

    public SpongeUserManager(MinecraftServer server) {
        this.server = server;
    }

    public void init() {
        this.refreshFilesystemProfiles();
        this.setupWatchers();
    }

    @Override
    public CompletableFuture<Optional<User>> load(UUID uniqueId) {
        return this.fetchUser(uniqueId, false).thenApply(x -> {
            if (x != null) {
                return Optional.of(SpongeUserView.create(uniqueId));
            }
            return Optional.empty();
        });
    }

    @Override
    public CompletableFuture<User> loadOrCreate(UUID uuid) {
        return this.fetchUser(uuid, true);
    }

    private CompletableFuture<@Nullable User> fetchUser(UUID uniqueId, boolean always) {
        UUID uuidToUse = this.ensureNonEmptyUUID(uniqueId);
        if (this.server.func_184103_al().func_177451_a(uniqueId) != null) {
            return CompletableFuture.completedFuture(SpongeUserView.create(uniqueId));
        }
        @Nullable SpongeUserData currentUser = (SpongeUserData)this.userCache.getIfPresent((Object)uuidToUse);
        if (currentUser != null) {
            return CompletableFuture.completedFuture(SpongeUserView.create(uuidToUse));
        }
        return CompletableFuture.supplyAsync(() -> {
            if (always || this.knownUUIDs.contains(uuidToUse)) {
                @Nullable GameProfile profile = this.server.func_152358_ax().func_152652_a(uuidToUse);
                try {
                    this.createUser(profile == null ? new GameProfile(uuidToUse, null) : profile);
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
                return SpongeUserView.create(uuidToUse);
            }
            return null;
        }, this.executorService);
    }

    @Override
    public CompletableFuture<Optional<User>> load(String lastKnownName) {
        Objects.requireNonNull(lastKnownName, "lastKnownName");
        if (lastKnownName.isEmpty() || lastKnownName.length() > 16) {
            throw new IllegalArgumentException(String.format("Invalid username %s", lastKnownName));
        }
        @Nullable GameProfile mcProfile = Sponge.server().gameProfileManager().cache().findByName(lastKnownName.toLowerCase(Locale.ROOT)).map(SpongeGameProfile::toMcProfile).orElse(null);
        if (mcProfile != null) {
            return this.load(mcProfile.getId());
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Optional<User>> load(org.spongepowered.api.profile.GameProfile profile) {
        return this.fetchUser(this.ensureNonEmptyUUID(profile.uniqueId()), false).thenApply(x -> {
            if (x != null) {
                return Optional.of(SpongeUserView.create(profile.uniqueId()));
            }
            return Optional.empty();
        });
    }

    @Override
    public Stream<org.spongepowered.api.profile.GameProfile> streamAll() {
        GameProfileCache cache = ((Server)this.server).gameProfileManager().cache();
        return this.knownUUIDs.stream().map(x -> cache.findById((UUID)x).orElseGet(() -> org.spongepowered.api.profile.GameProfile.of(x)));
    }

    @Override
    public CompletableFuture<Boolean> delete(UUID uuid) {
        if (SpongeCommon.server().func_184103_al().func_177451_a(Objects.requireNonNull(uuid, "uuid")) != null) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            @Nullable Path dataFile = this.getPlayerDataFile(uuid);
            if (dataFile != null) {
                try {
                    if (Files.deleteIfExists(dataFile)) {
                        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
                        if (data != null) {
                            this.dirtyUsers.remove(data);
                        }
                        this.userCache.invalidate((Object)uuid);
                    }
                }
                catch (IOException | SecurityException e) {
                    SpongeCommon.logger().warn("Unable to delete file {}", (Object)dataFile, (Object)e);
                    return false;
                }
            }
            return true;
        }, this.executorService);
    }

    @Override
    public boolean removeFromCache(UUID uuid) {
        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
        if (data != null) {
            this.dirtyUsers.remove(data);
            this.userCache.invalidate((Object)uuid);
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Boolean> forceSave(UUID uuid) {
        @Nullable SpongeUserData data = (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
        if (data != null && this.dirtyUsers.contains(data)) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    data.save();
                }
                catch (IOException e) {
                    throw new CompletionException(e);
                }
                return true;
            });
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public boolean exists(UUID playerUuid) {
        if (this.userCache.getIfPresent((Object)playerUuid) == null) {
            @Nullable Path path = this.getPlayerDataFile(playerUuid);
            return path != null && Files.exists(path, new LinkOption[0]);
        }
        return true;
    }

    @Override
    public Stream<org.spongepowered.api.profile.GameProfile> streamOfMatches(String lastKnownName) {
        String nameToCheck = Objects.requireNonNull(lastKnownName, "lastKnownName").toLowerCase(Locale.ROOT);
        return ((Server)this.server).gameProfileManager().cache().streamOfMatches(nameToCheck).filter(gameProfile -> this.exists(gameProfile.uuid()));
    }

    private UUID ensureNonEmptyUUID(UUID uuid) {
        if (uuid.equals(SpongeGameProfile.EMPTY_UUID)) {
            return FAKEPLAYER_UUID;
        }
        return uuid;
    }

    public void handlePlayerLogin(GameProfile mcProfile) throws IOException {
        @Nullable SpongeUserData currentUser = (SpongeUserData)this.userCache.getIfPresent((Object)mcProfile.getId());
        if (currentUser != null) {
            if (this.dirtyUsers.contains(currentUser)) {
                currentUser.save();
            }
            this.userCache.invalidate((Object)currentUser.uniqueId());
        }
    }

    private void createUser(GameProfile profile) throws IOException {
        this.pollFilesystemWatcher();
        @Nullable SpongeUserData user = SpongeUserData.create(profile);
        this.userCache.put((Object)profile.getId(), (Object)user);
        this.knownUUIDs.add(profile.getId());
    }

    public void markDirty(SpongeUserData user) {
        if (user != this.userCache.getIfPresent((Object)user.uniqueId())) {
            SpongeCommon.logger().error("User {} is either online or the data has has dropped out of the cache and will not be saved.", (Object)user.uniqueId());
        } else {
            this.dirtyUsers.add(user);
        }
    }

    void setupWatchers() {
        this.teardownWatchers();
        try {
            this.filesystemWatchService = FileSystems.getDefault().newWatchService();
            this.watchKey = this.getSaveHandlerDirectory().register(this.filesystemWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            SpongeCommon.logger().warn("Could not start file watcher");
            if (this.filesystemWatchService != null) {
                try {
                    this.filesystemWatchService.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.watchKey = null;
            this.filesystemWatchService = null;
        }
    }

    void teardownWatchers() {
        if (this.watchKey != null) {
            this.watchKey.cancel();
            this.watchKey = null;
        }
        if (this.filesystemWatchService != null) {
            try {
                this.filesystemWatchService.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.filesystemWatchService = null;
            }
        }
    }

    void refreshFilesystemProfiles() {
        String[] uuids;
        if (this.watchKey != null && this.watchKey.isValid()) {
            this.watchKey.reset();
        }
        this.knownUUIDs.clear();
        this.userCache.invalidateAll();
        for (String playerUuid : uuids = this.getSaveHandler().func_237334_a_()) {
            UUID uuid;
            if (playerUuid.contains(".")) continue;
            try {
                uuid = UUID.fromString(playerUuid);
            }
            catch (Exception ex) {
                continue;
            }
            this.knownUUIDs.add(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollFilesystemWatcher() {
        if (this.watchKey == null || !this.watchKey.isValid()) {
            this.refreshFilesystemProfiles();
            this.setupWatchers();
            return;
        }
        Map<String, SpongeUserMutableWatchEvent> map = this.watcherUpdateMap;
        synchronized (map) {
            this.watcherUpdateMap.clear();
            for (WatchEvent<?> watchEvent : this.watchKey.pollEvents()) {
                WatchEvent<?> ev = watchEvent;
                @Nullable Path file = (Path)ev.context();
                if (file == null) continue;
                String filename = file.getFileName().toString();
                this.watcherUpdateMap.computeIfAbsent(filename, f -> new SpongeUserMutableWatchEvent()).set(ev.kind());
            }
            for (Map.Entry entry : this.watcherUpdateMap.entrySet()) {
                String name;
                WatchEvent.Kind<?> kind = ((SpongeUserMutableWatchEvent)entry.getValue()).get();
                if (kind == null || !(name = (String)entry.getKey()).endsWith(".dat")) continue;
                try {
                    UUID uuid = UUID.fromString(name.substring(0, name.length() - 4));
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.knownUUIDs.add(uuid);
                        continue;
                    }
                    this.knownUUIDs.remove(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private @Nullable Path getPlayerDataFile(UUID uniqueId) {
        Path file = this.getSaveHandlerDirectory().resolve(uniqueId + ".dat");
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        return null;
    }

    private PlayerData getSaveHandler() {
        return ((PlayerListAccessor)this.server.func_184103_al()).accessor$playerIo();
    }

    private Path getSaveHandlerDirectory() {
        return ((PlayerDataStorageAccessor)this.getSaveHandler()).accessor$playerDir().toPath();
    }

    public void saveDirtyUsers() {
        this.dirtyUsers.removeIf(SpongeUserData::isOnline);
        for (SpongeUserData user : new HashSet<SpongeUserData>(this.dirtyUsers)) {
            try {
                user.save();
            }
            catch (IOException iOException) {}
        }
    }

    public void unmarkDirty(SpongeUserData user) {
        this.dirtyUsers.remove(user);
    }

    public @Nullable SpongeUserData userFromCache(UUID uuid) {
        return (SpongeUserData)this.userCache.getIfPresent((Object)uuid);
    }

    public @Nullable User asUser(SpongeUserData spongeUserData) {
        if (this.userCache.getIfPresent((Object)spongeUserData.uniqueId()) == spongeUserData) {
            return SpongeUserView.create(spongeUserData.uniqueId());
        }
        return null;
    }
}

