/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class CommandUtil {
    private static final String[] EMPTY_COMMAND_ARRAY = new String[]{""};
    private static final Pattern INTEGER_PATTERN = Pattern.compile("\\d+");

    public static boolean checkForCustomSuggestions(CommandNode<?> rootSuggestion) {
        return rootSuggestion.getChildren().stream().filter(x -> x instanceof ArgumentCommandNode).anyMatch(x -> ((ArgumentCommandNode)x).getCustomSuggestions() != null);
    }

    public static CompletableFuture<Suggestions> buildSuggestionsFromCompletions(List<CommandCompletion> commandCompletions, SuggestionsBuilder builder) {
        for (CommandCompletion completion : commandCompletions) {
            String s2 = completion.completion();
            Message m4 = completion.tooltip().map(SpongeAdventure::asVanilla).orElse(null);
            if (INTEGER_PATTERN.matcher(s2).matches()) {
                try {
                    builder.suggest(Integer.parseInt(s2), m4);
                }
                catch (NumberFormatException ex) {
                    builder.suggest(s2, m4);
                }
                continue;
            }
            builder.suggest(s2, m4);
        }
        return builder.buildFuture();
    }

    public static SuggestionsBuilder createSuggestionsForRawCommand(String rawCommand, String[] commandArray, CommandCause cause, CommandMapping mapping) {
        SuggestionsBuilder builder = new SuggestionsBuilder(rawCommand, rawCommand.lastIndexOf(" ") + 1);
        try {
            mapping.registrar().complete(cause, mapping, commandArray[0], commandArray[1]).forEach(completion -> builder.suggest(completion.completion(), (Message)completion.tooltip().map(SpongeAdventure::asVanilla).orElse(null)));
        }
        catch (CommandException ex) {
            SpongeCommon.logger().error("Could not determine completions for {}", (Object)rawCommand);
            SpongeCommon.logger().error(ex);
        }
        return builder;
    }

    public static String[] extractCommandString(String commandString) {
        if (commandString.isEmpty()) {
            return EMPTY_COMMAND_ARRAY;
        }
        if (commandString.startsWith("/")) {
            return commandString.substring(1).split(" ", 2);
        }
        return commandString.split(" ", 2);
    }

    private CommandUtil() {
    }
}

