/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.Server;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class DamageEventUtil {
    public static final DoubleUnaryOperator HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);

    private DamageEventUtil() {
    }

    public static DoubleUnaryOperator createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - Math.max(damage * (double)modifier / 25.0, 0.0));
    }

    public static Optional<DamageFunction> createHardHatModifier(LivingEntity living, DamageSource damageSource) {
        if (damageSource instanceof FallingBlockDamageSource && !living.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((ItemStack)living.func_184582_a(EquipmentSlotType.HEAD)).createSnapshot())).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new DamageFunction(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createArmorModifiers(LivingEntity living, DamageSource damageSource) {
        DamageFunction armorModifier;
        if (damageSource.func_76363_c()) {
            return Optional.empty();
        }
        DoubleUnaryOperator function = incomingDamage -> -(incomingDamage - (double)CombatRules.func_189427_a((float)((float)incomingDamage), (float)living.func_70658_aO(), (float)((float)living.func_233637_b_(Attributes.field_233827_j_))));
        try (CauseStackManager.StackFrame frame = ((Server)living.func_184102_h()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            frame.pushCause(Attributes.field_233827_j_);
            armorModifier = DamageFunction.of(DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR).build(), function);
        }
        return Optional.of(armorModifier);
    }

    public static Optional<DamageFunction> createResistanceModifier(LivingEntity living, DamageSource damageSource) {
        PotionEffect effect = (PotionEffect)living.func_70660_b(Effects.field_76429_m);
        if (!damageSource.func_151517_h() && effect != null && damageSource != DamageSource.field_76380_i) {
            return Optional.of(new DamageFunction(DamageModifier.builder().cause(Cause.of(EventContext.empty(), effect)).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventUtil.createResistanceFunction(effect.amplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createEnchantmentModifiers(LivingEntity living, DamageSource damageSource) {
        if (damageSource.func_151517_h()) {
            return Optional.empty();
        }
        Iterable inventory = living.func_184193_aE();
        int damageProtection = EnchantmentHelper.func_77508_a((Iterable)inventory, (DamageSource)damageSource);
        if (damageProtection <= 0) {
            return Optional.empty();
        }
        ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
        DoubleUnaryOperator enchantmentFunction = incomingDamage -> -(incomingDamage - (double)CombatRules.func_188401_b((float)((float)incomingDamage), (float)damageProtection));
        try (CauseStackManager.StackFrame frame = ((Server)living.func_184102_h()).causeStackManager().pushCauseFrame();){
            frame.pushCause(living);
            DamageModifier enchantmentModifier = DamageModifier.builder().cause(frame.currentCause()).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
            modifiers.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return Optional.of(modifiers);
    }

    public static Optional<DamageFunction> createAbsorptionModifier(LivingEntity living) {
        float absorptionAmount = living.func_110139_bj();
        if (absorptionAmount > 0.0f) {
            DoubleUnaryOperator function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), living)).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new DamageFunction(modifier, function));
        }
        return Optional.empty();
    }

    public static ServerLocation findFirstMatchingBlock(net.minecraft.entity.Entity entity, AxisAlignedBB bb, Predicate<BlockState> predicate) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(bb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(bb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(bb.field_72334_f + 1.0));
        AbstractChunkProvider chunkSource = entity.field_70170_p.func_72863_F();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    Chunk chunk = chunkSource.func_217205_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, false);
                    if (chunk == null || chunk.func_76621_g() || !predicate.test(chunk.func_180495_p(blockPos))) continue;
                    return ServerLocation.of((ServerWorld)entity.field_70170_p, k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).serverLocation();
    }

    public static void generateCauseFor(DamageSource damageSource, CauseStackManager.StackFrame frame) {
        if (damageSource instanceof EntityDamageSource) {
            net.minecraft.entity.Entity source = damageSource.func_76346_g();
            if (!(source instanceof PlayerEntity) && source instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)source;
                creatorBridge.tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (damageSource instanceof BlockDamageSource) {
            ServerLocation location = ((BlockDamageSource)damageSource).location();
            BlockPos blockPos = VecHelper.toBlockPos(location);
            LevelChunkBridge chunkBridge = (LevelChunkBridge)((World)location.world()).func_175726_f(blockPos);
            chunkBridge.bridge$getBlockCreatorUUID(blockPos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            chunkBridge.bridge$getBlockNotifierUUID(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
        }
        frame.pushCause(damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(net.minecraft.item.ItemStack heldItem, CreatureAttribute creatureAttribute, float attackStrength) {
        if (heldItem.func_190926_b()) {
            return Collections.emptyList();
        }
        ListNBT enchantmentCompounds = heldItem.func_77986_q();
        if (enchantmentCompounds.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Enchantment, Collection> enchantments = new HashMap<Enchantment, Collection>();
        for (int i = 0; i < enchantmentCompounds.size(); ++i) {
            String id = enchantmentCompounds.func_150305_b(i).func_74779_i("id");
            int enchantmentLevel = enchantmentCompounds.func_150305_b(i).func_74762_e("lvl");
            Enchantment enchantment = (Enchantment)Registry.field_212628_q.func_82594_a(new ResourceLocation(id));
            if (enchantment == null) continue;
            enchantments.computeIfAbsent(enchantment, k -> new ArrayList()).add(enchantmentLevel);
        }
        if (enchantments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DamageFunction> damageModifierFunctions = new ArrayList<DamageFunction>();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(heldItem);
        for (Map.Entry entry : enchantments.entrySet()) {
            DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.of(EventContext.empty(), snapshot, entry)).build();
            DoubleUnaryOperator enchantmentFunction = damage -> {
                double totalDamage = 0.0;
                Iterator iterator = ((Collection)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int level = (Integer)iterator.next();
                    totalDamage += (double)((Enchantment)entry.getKey()).func_152376_a(level, creatureAttribute) * (double)attackStrength;
                }
                return totalDamage;
            };
            damageModifierFunctions.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
        }
        return damageModifierFunctions;
    }

    public static DamageFunction provideCriticalAttackTuple(PlayerEntity player, double criticalModifier) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.CRITICAL_HIT).build();
        DoubleUnaryOperator function = damage -> damage * criticalModifier;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(PlayerEntity player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        DoubleUnaryOperator function = damage -> -damage + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static Optional<DamageFunction> createShieldFunction(LivingEntity entity, DamageSource source, float amount) {
        if (entity.func_184585_cz() && (double)amount > 0.0 && ((LivingEntityAccessor)entity).invoker$isDamageSourceBlocked(source)) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entity, ((ItemStack)entity.func_184607_cu()).createSnapshot())).type(DamageModifierTypes.SHIELD).build();
            return Optional.of(new DamageFunction(modifier, damage -> -damage));
        }
        return Optional.empty();
    }
}

