/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.NonNullList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.Constants;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public final class DataUtil {
    public static DataView checkDataExists(DataView dataView, DataQuery query) throws InvalidDataException {
        if (!((DataView)Preconditions.checkNotNull((Object)dataView)).contains((DataQuery)Preconditions.checkNotNull((Object)query))) {
            throw new InvalidDataException("Missing data for query: " + query.asString('.'));
        }
        return dataView;
    }

    public static ServerLocation getLocation(DataView view, boolean castToInt) {
        ResourceKey world = view.getResourceKey(Queries.WORLD_KEY).orElseThrow(DataUtil.dataNotFound());
        Vector3d pos = DataUtil.getPosition3d(view, null);
        if (castToInt) {
            return ServerLocation.of(SpongeCommon.game().server().worldManager().world(world).orElseThrow(DataUtil.dataNotFound()), pos.toInt());
        }
        return ServerLocation.of(SpongeCommon.game().server().worldManager().world(world).orElseThrow(DataUtil.dataNotFound()), pos);
    }

    public static Vector3i getPosition3i(DataView view) {
        DataUtil.checkDataExists(view, Constants.Sponge.SNAPSHOT_WORLD_POSITION);
        DataView internal = view.getView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).orElseThrow(DataUtil.dataNotFound());
        int x = internal.getInt(Queries.POSITION_X).orElseThrow(DataUtil.dataNotFound());
        int y = internal.getInt(Queries.POSITION_Y).orElseThrow(DataUtil.dataNotFound());
        int z = internal.getInt(Queries.POSITION_Z).orElseThrow(DataUtil.dataNotFound());
        return new Vector3i(x, y, z);
    }

    private static Supplier<InvalidDataException> dataNotFound() {
        return () -> new InvalidDataException("not found");
    }

    public static Vector3d getPosition3d(DataView view, @Nullable DataQuery query) {
        DataView internal = query == null ? view : view.getView(query).orElseThrow(DataUtil.dataNotFound());
        double x = internal.getDouble(Queries.POSITION_X).orElseThrow(DataUtil.dataNotFound());
        double y = internal.getDouble(Queries.POSITION_Y).orElseThrow(DataUtil.dataNotFound());
        double z = internal.getDouble(Queries.POSITION_Z).orElseThrow(DataUtil.dataNotFound());
        return new Vector3d(x, y, z);
    }

    public static <E> Collection<E> ensureMutable(Collection<E> collection) {
        if (collection instanceof List) {
            return DataUtil.ensureMutable((List)collection);
        }
        if (collection instanceof Set) {
            return DataUtil.ensureMutable((Set)collection);
        }
        if (collection instanceof WeightedTable) {
            return DataUtil.ensureMutable((WeightedTable)collection);
        }
        return new ArrayList<E>(collection);
    }

    public static <T> WeightedTable<T> ensureMutable(WeightedTable<T> table) {
        Class<?> type = table.getClass();
        if (type == WeightedTable.class) {
            return table;
        }
        WeightedTable copy = new WeightedTable(table.rolls());
        copy.addAll(table);
        return copy;
    }

    public static <E> List<E> ensureMutable(List<E> list) {
        Class<?> type = list.getClass();
        if (type == ArrayList.class || type == LinkedList.class || type == CopyOnWriteArrayList.class || type == Stack.class || type == Vector.class || type == NonNullList.class) {
            return list;
        }
        return new ArrayList<E>(list);
    }

    public static <E> Set<E> ensureMutable(Set<E> set) {
        Class<?> type = set.getClass();
        if (type == HashSet.class || type == LinkedHashSet.class || type == ConcurrentSkipListSet.class) {
            return set;
        }
        return new LinkedHashSet<E>(set);
    }

    public static <K, V> Map<K, V> ensureMutable(Map<K, V> map) {
        Class<?> type = map.getClass();
        if (type == HashMap.class || type == LinkedHashMap.class || type == TreeMap.class || type == ConcurrentHashMap.class) {
            return map;
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static double mind(Property<Double> property) {
        return property.func_177700_c().stream().mapToDouble(i -> i).min().getAsDouble();
    }

    public static double maxd(Property<Double> property) {
        return property.func_177700_c().stream().mapToDouble(i -> i).max().getAsDouble();
    }

    public static int mini(IntegerProperty property) {
        return property.func_177700_c().stream().mapToInt(i -> i).min().getAsInt();
    }

    public static int maxi(IntegerProperty property) {
        return property.func_177700_c().stream().mapToInt(i -> i).max().getAsInt();
    }

    public static <E, V extends Value<E>> E merge(MergeFunction function, Key<V> key, @Nullable E original, @Nullable E replacement) {
        @Nullable V originalValue = original == null ? null : (Value)Value.genericImmutableOf(key, original);
        @Nullable V value = replacement == null ? null : (Value)Value.genericImmutableOf(key, replacement);
        return ((Value)Preconditions.checkNotNull(function.merge(originalValue, value), (Object)"merged")).get();
    }

    public static <E, V extends Value<E>> E merge(MergeFunction function, Key<V> key, Supplier<@Nullable E> original, Supplier<@Nullable E> replacement) {
        if (function == MergeFunction.ORIGINAL_PREFERRED) {
            return original.get();
        }
        if (function == MergeFunction.REPLACEMENT_PREFERRED) {
            return replacement.get();
        }
        @Nullable E originalElement = original.get();
        @Nullable E replacementElement = replacement.get();
        @Nullable V originalValue = originalElement == null ? null : (Value)Value.genericImmutableOf(key, originalElement);
        @Nullable V replacementValue = replacementElement == null ? null : (Value)Value.genericImmutableOf(key, replacementElement);
        return ((Value)Preconditions.checkNotNull(function.merge(originalValue, replacementValue), (Object)"merged")).get();
    }

    private DataUtil() {
    }
}

