/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import org.spongepowered.api.util.Direction;

public final class DirectionUtil {
    public static net.minecraft.util.Direction getFor(Direction direction) {
        Objects.requireNonNull(direction);
        switch (direction) {
            case UP: {
                return net.minecraft.util.Direction.UP;
            }
            case DOWN: {
                return net.minecraft.util.Direction.DOWN;
            }
            case WEST: {
                return net.minecraft.util.Direction.WEST;
            }
            case SOUTH: {
                return net.minecraft.util.Direction.SOUTH;
            }
            case EAST: {
                return net.minecraft.util.Direction.EAST;
            }
            case NORTH: {
                return net.minecraft.util.Direction.NORTH;
            }
        }
        return null;
    }

    public static Direction getFor(net.minecraft.util.Direction facing) {
        Preconditions.checkNotNull((Object)facing);
        switch (facing) {
            case UP: {
                return Direction.UP;
            }
            case DOWN: {
                return Direction.DOWN;
            }
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case NORTH: {
                return Direction.NORTH;
            }
        }
        throw new IllegalStateException();
    }

    public static BlockState set(BlockState holder, Direction value, DirectionProperty property) {
        net.minecraft.util.Direction direction = DirectionUtil.getFor(value);
        if (direction == null || !property.func_177700_c().contains(direction)) {
            return holder;
        }
        return (BlockState)holder.func_206870_a((Property)property, (Comparable)direction);
    }

    public static Direction fromRotation(int i) {
        switch (i) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.SOUTH_SOUTHWEST;
            }
            case 2: {
                return Direction.SOUTHWEST;
            }
            case 3: {
                return Direction.WEST_SOUTHWEST;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.WEST_NORTHWEST;
            }
            case 6: {
                return Direction.NORTHWEST;
            }
            case 7: {
                return Direction.NORTH_NORTHWEST;
            }
            case 8: {
                return Direction.NORTH;
            }
            case 9: {
                return Direction.NORTH_NORTHEAST;
            }
            case 10: {
                return Direction.NORTHEAST;
            }
            case 11: {
                return Direction.EAST_NORTHEAST;
            }
            case 12: {
                return Direction.EAST;
            }
            case 13: {
                return Direction.EAST_SOUTHEAST;
            }
            case 14: {
                return Direction.SOUTHEAST;
            }
            case 15: {
                return Direction.SOUTH_SOUTHEAST;
            }
        }
        return Direction.NORTH;
    }

    public static int toRotation(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 0;
            }
            case SOUTH_SOUTHWEST: {
                return 1;
            }
            case SOUTHWEST: {
                return 2;
            }
            case WEST_SOUTHWEST: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case WEST_NORTHWEST: {
                return 5;
            }
            case NORTHWEST: {
                return 6;
            }
            case NORTH_NORTHWEST: {
                return 7;
            }
            case NORTH: {
                return 8;
            }
            case NORTH_NORTHEAST: {
                return 9;
            }
            case NORTHEAST: {
                return 10;
            }
            case EAST_NORTHEAST: {
                return 11;
            }
            case EAST: {
                return 12;
            }
            case EAST_SOUTHEAST: {
                return 13;
            }
            case SOUTHEAST: {
                return 14;
            }
            case SOUTH_SOUTHEAST: {
                return 15;
            }
        }
        return 0;
    }

    public static Direction fromHorizontalHanging(int i) {
        switch (i) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
        }
        return Direction.NORTH;
    }

    public static int toHorizontalHanging(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case EAST: {
                return 3;
            }
        }
        return 0;
    }

    public static Direction fromHanging(int i) {
        switch (i) {
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.UP;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.SOUTH;
            }
            case 4: {
                return Direction.WEST;
            }
            case 5: {
                return Direction.EAST;
            }
        }
        return Direction.DOWN;
    }

    public static int toHanging(Direction direction) {
        switch (direction) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 0;
    }

    public static int directionToIndex(Direction direction) {
        switch (direction) {
            case NORTH: 
            case NORTHWEST: 
            case NORTHEAST: {
                return 0;
            }
            case SOUTH: 
            case SOUTHWEST: 
            case SOUTHEAST: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unexpected direction");
    }

    private DirectionUtil() {
    }
}

