/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.primitives.Bytes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.registry.SimpleRegistry;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorType;
import org.spongepowered.api.map.color.MapShade;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.map.color.SpongeMapColor;
import org.spongepowered.common.util.Constants;

public final class MapUtil {
    public static boolean isInCanvasBounds(int i) {
        return i >= 0 && i < 128;
    }

    public static boolean isInMapDecorationBounds(int i) {
        return i >= -128 && i <= 127;
    }

    public static Optional<MapColor> getMapColorFromPixelValue(byte value) {
        int intColor = Byte.toUnsignedInt(value);
        int shade = intColor % 4;
        int colorIndex = (intColor - shade) / 4;
        Optional<MapColorType> mapColorType = MapUtil.getMapColorTypeByColorIndex(colorIndex);
        MapShade mapShade = MapUtil.getMapShadeById(shade);
        if (!mapColorType.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SpongeMapColor(mapColorType.get(), mapShade));
    }

    public static byte[] getMapCanvasFromContainer(DataView container) {
        DataQuery canvasQuery = Constants.Map.MAP_CANVAS;
        List<Byte> data = container.getByteList(canvasQuery).orElseThrow(() -> new InvalidDataException(canvasQuery + " was not a byte list!"));
        if (data.size() != 16384) {
            throw new InvalidDataException(canvasQuery + "had incorrect length, expected: " + 16384 + ", got: " + data.size());
        }
        HashSet<Byte> validPixels = new HashSet<Byte>();
        for (Byte pixel : data) {
            if (validPixels.contains(pixel)) continue;
            MapUtil.getMapColorFromPixelValue(pixel).orElseThrow(() -> new InvalidDataException("Invalid pixel value: " + pixel));
            validPixels.add(pixel);
        }
        return Bytes.toArray(data);
    }

    public static int normalizeDecorationOrientation(byte rotation) {
        return Math.floorMod(rotation, 16);
    }

    public static Optional<MapColorType> getMapColorTypeByColorIndex(int colorIndex) {
        return Optional.ofNullable((MapColorType)((SimpleRegistry)RegistryTypes.MAP_COLOR_TYPE.get()).func_148745_a(colorIndex));
    }

    public static MapShade getMapShadeById(int id) {
        return (MapShade)((SimpleRegistry)RegistryTypes.MAP_SHADE.get()).func_148745_a(id);
    }

    public static void saveMapUUIDIndex(CompoundNBT tag, Map<Integer, UUID> index) {
        for (Map.Entry<Integer, UUID> entry : index.entrySet()) {
            tag.func_186854_a(String.valueOf(entry.getKey()), entry.getValue());
        }
    }

    public static MapDecorationOrientation getMapRotById(int intRot) {
        MapDecorationOrientation orientation = (MapDecorationOrientation)((SimpleRegistry)RegistryTypes.MAP_DECORATION_ORIENTATION.get()).func_148745_a(intRot);
        if (orientation == null) {
            throw new InvalidDataException(intRot + " is not a valid number for a MapDecorationOrientation");
        }
        return orientation;
    }
}

